/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.entrypoint;

import corgiaoc.byg.BYG;
import corgiaoc.byg.common.world.feature.blockplacer.BYGBlockPlacerTypes;
import corgiaoc.byg.core.BYGBlocks;
import corgiaoc.byg.core.BYGEntities;
import corgiaoc.byg.core.BYGItems;
import corgiaoc.byg.core.BYGSounds;
import corgiaoc.byg.core.BYGTileEntities;
import corgiaoc.byg.core.world.BYGBiomes;
import corgiaoc.byg.core.world.BYGContainerTypes;
import corgiaoc.byg.core.world.BYGDecorators;
import corgiaoc.byg.core.world.BYGFeatures;
import corgiaoc.byg.core.world.BYGStructures;
import corgiaoc.byg.core.world.BYGSurfaceBuilders;
import corgiaoc.byg.entrypoint.EntryPoint;
import corgiaoc.byg.mixin.access.FillerBlockTypeAccess;
import corgiaoc.byg.util.MLBlockTags;
import corgiaoc.byg.util.NetworkUtil;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_3031;
import net.minecraft.class_3284;
import net.minecraft.class_3414;
import net.minecraft.class_3481;
import net.minecraft.class_3494;
import net.minecraft.class_3523;
import net.minecraft.class_3798;
import net.minecraft.class_3825;
import net.minecraft.class_3917;
import net.minecraft.class_4630;

public class FabricEntryPoint
implements EntryPoint,
ModInitializer {
    public static class_2960 SPAWN_PACKET_ID = new class_2960("byg", "custom_spawn_packet");

    public FabricEntryPoint() {
        BYG.entryPoint = this;
        BYG.CONFIG_PATH = this.configDirectory();
    }

    public void onInitialize() {
        FabricEntryPoint.bootStrap();
        FabricEntryPoint.commonSetup();
        this.loadComplete();
        class_3494.class_5123<class_2248> dirt = MLBlockTags.DIRT;
    }

    private static void commonSetup() {
        BYG.commonLoad();
        BYG.threadSafeCommonLoad();
    }

    private void loadComplete() {
        BYG.threadSafeLoadFinish();
    }

    @Override
    public Path configDirectory() {
        return FabricLoader.getInstance().getConfigDir().resolve("byg");
    }

    @Override
    public class_2596<?> getEntitySpawnPacket(class_1297 entity) {
        return NetworkUtil.getEntitySpawnPacket(entity);
    }

    public static void bootStrap() {
        FabricEntryPoint.registerBlocks();
        FabricEntryPoint.registerItems();
        FabricEntryPoint.registerEntities();
        FabricEntryPoint.registerTileEntities();
        FabricEntryPoint.registerSounds();
        FabricEntryPoint.registerContainers();
        FabricEntryPoint.registerBiomes();
        FabricEntryPoint.registerDecorators();
        FabricEntryPoint.registerStructures();
        FabricEntryPoint.registerFeatures();
        FabricEntryPoint.registerSurfaceBuilders();
        FabricEntryPoint.registerBlockPlacerType();
    }

    public static void registerBlocks() {
        BYG.LOGGER.debug("BYG: Registering blocks...");
        List<class_2248> blocksList = BYGBlocks.blocksList;
        List<class_2248> flowerPotBlocks = BYGBlocks.flowerPotBlocks;
        BYG.LOGGER.info("BYG: Blocks registered!");
    }

    public static void registerItems() {
        BYG.LOGGER.debug("BYG: Registering items...");
        List<class_1792> itemsList = BYGItems.itemsList;
        BYG.LOGGER.info("BYG: Items registered!");
    }

    public static void registerEntities() {
        BYG.LOGGER.debug("BYG: Registering entities...");
        Set<class_1299<?>> entities = BYGEntities.entities;
        BYG.LOGGER.info("BYG: Entities registered!");
    }

    public static void registerTileEntities() {
        BYG.LOGGER.debug("BYG: Registering block entities...");
        List<class_2591<?>> blockEntities = BYGTileEntities.BLOCK_ENTITIES;
        BYG.LOGGER.info("BYG: Block Entities registered!");
    }

    public static void registerSounds() {
        BYG.LOGGER.debug("BYG: Registering sounds...");
        List<class_3414> sounds = BYGSounds.SOUNDS;
        BYG.LOGGER.info("BYG: Sounds registered!");
    }

    public static void registerContainers() {
        BYG.LOGGER.debug("BYG: Registering block entities...");
        BYGEntities.init();
        List<class_3917<?>> containerTypes = BYGContainerTypes.CONTAINER_TYPES;
        BYG.LOGGER.info("BYG: Block Entities registered!");
    }

    public static void registerBiomes() {
        BYG.LOGGER.debug("BYG: Registering biomes...");
        BYGBiomes.init();
        BYGBiomes.biomeList.sort(Comparator.comparingInt(BYGBiomes.PreserveBiomeOrder::getOrderPosition));
        BYGBiomes.CANYON_KEY = BYGBiomes.CANYON.getKey();
        BYG.LOGGER.info("BYG: Biomes registered!");
    }

    public static void registerDecorators() {
        BYG.LOGGER.debug("BYG: Registering decorators...");
        BYGDecorators.init();
        List<class_3284<?>> decorators = BYGDecorators.decorators;
        BYG.LOGGER.info("BYG: Decorators registered!");
    }

    public static void registerStructures() {
        BYG.LOGGER.debug("BYG: Registering structures...");
        BYGStructures.init();
        BYG.LOGGER.info("BYG: Structures registered!");
    }

    public static void registerFeatures() {
        BYG.LOGGER.debug("BYG: Registering features...");
        FillerBlockTypeAccess.setNetherFillerType((class_3825)new class_3798((class_3494)class_3481.field_25807));
        BYGFeatures.init();
        List<class_3031<?>> features = BYGFeatures.features;
        BYG.LOGGER.info("BYG: Features registered!");
    }

    public static void registerSurfaceBuilders() {
        BYG.LOGGER.debug("BYG: Registering surface builders...");
        BYGSurfaceBuilders.init();
        List<class_3523<?>> surfaceBuilders = BYGSurfaceBuilders.surfaceBuilders;
        BYG.LOGGER.info("BYG: Surface builders Registered!");
    }

    public static void registerBlockPlacerType() {
        BYG.LOGGER.debug("BYG: Registering block placer types...");
        BYGBlockPlacerTypes.init();
        List<class_4630<?>> types = BYGBlockPlacerTypes.types;
        BYG.LOGGER.info("BYG: Registering block placer types!");
    }
}

