/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power;

import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.power.Power;
import io.github.apace100.origins.power.factory.PowerFactory;
import io.github.apace100.origins.registry.ModComponents;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2588;
import net.minecraft.class_2960;

public class PowerType<T extends Power> {
    private class_2960 identifier;
    private PowerFactory.Instance factory;
    private boolean isHidden = false;
    private String nameTranslationKey;
    private String descriptionTranslationKey;

    public PowerType(class_2960 id, PowerFactory.Instance factory) {
        this.identifier = id;
        this.factory = factory;
    }

    public class_2960 getIdentifier() {
        return this.identifier;
    }

    public PowerFactory.Instance getFactory() {
        return this.factory;
    }

    public PowerType setHidden() {
        this.isHidden = true;
        return this;
    }

    public void setTranslationKeys(String name, String description) {
        this.nameTranslationKey = name;
        this.descriptionTranslationKey = description;
    }

    public T create(class_1657 player) {
        return (T)this.factory.apply(this, player);
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public boolean isActive(class_1297 entity) {
        OriginComponent component;
        if (entity instanceof class_1657 && this.identifier != null && (component = (OriginComponent)ModComponents.ORIGIN.get((Object)entity)).hasPower(this)) {
            return ((Power)component.getPower(this)).isActive();
        }
        return false;
    }

    public T get(class_1297 entity) {
        if (entity instanceof class_1657) {
            OriginComponent component = (OriginComponent)ModComponents.ORIGIN.get((Object)entity);
            return component.getPower(this);
        }
        return null;
    }

    public String getOrCreateNameTranslationKey() {
        if (this.nameTranslationKey == null || this.nameTranslationKey.isEmpty()) {
            this.nameTranslationKey = "power." + this.identifier.method_12836() + "." + this.identifier.method_12832() + ".name";
        }
        return this.nameTranslationKey;
    }

    public class_2588 getName() {
        return new class_2588(this.getOrCreateNameTranslationKey());
    }

    public String getOrCreateDescriptionTranslationKey() {
        if (this.descriptionTranslationKey == null || this.descriptionTranslationKey.isEmpty()) {
            this.descriptionTranslationKey = "power." + this.identifier.method_12836() + "." + this.identifier.method_12832() + ".description";
        }
        return this.descriptionTranslationKey;
    }

    public class_2588 getDescription() {
        return new class_2588(this.getOrCreateDescriptionTranslationKey());
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PowerType)) {
            return false;
        }
        class_2960 id = ((PowerType)obj).getIdentifier();
        return this.identifier.equals((Object)id);
    }
}

