/*
 * Decompiled with CFR 0.152.
 */
package io.github.joaoh1.okzoomer.client.mixin;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.joaoh1.okzoomer.client.config.OkZoomerConfigPojo;
import io.github.joaoh1.okzoomer.client.utils.ZoomUtils;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_757;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_757.class})
public class GameRendererMixin {
    @Unique
    private static final class_2960 ZOOM_OVERLAY = new class_2960("okzoomer:textures/misc/zoom_overlay.png");
    @Final
    @Shadow
    private class_310 field_4015;

    @Inject(at={@At(value="HEAD")}, method={"tick()V"})
    private void zoomTick(CallbackInfo info) {
        if (!OkZoomerConfigPojo.features.zoomTransition.equals((Object)OkZoomerConfigPojo.FeaturesGroup.ZoomTransitionOptions.OFF)) {
            ZoomUtils.updateZoomFovMultiplier();
        }
        if (OkZoomerConfigPojo.features.zoomOverlay) {
            ZoomUtils.updateZoomOverlayAlpha();
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"getFov(Lnet/minecraft/client/render/Camera;FZ)D"}, cancellable=true)
    private double getZoomedFov(class_4184 camera, float tickDelta, boolean changingFov, CallbackInfoReturnable<Double> info) {
        double fov = (Double)info.getReturnValue();
        if (!OkZoomerConfigPojo.features.zoomTransition.equals((Object)OkZoomerConfigPojo.FeaturesGroup.ZoomTransitionOptions.OFF)) {
            if (ZoomUtils.zoomFovMultiplier != 1.0f) {
                info.setReturnValue((Object)(fov *= (double)class_3532.method_16439((float)tickDelta, (float)ZoomUtils.lastZoomFovMultiplier, (float)ZoomUtils.zoomFovMultiplier)));
            }
        } else if (ZoomUtils.zoomState) {
            double zoomedFov = fov / ZoomUtils.zoomDivisor;
            info.setReturnValue((Object)zoomedFov);
        }
        if (ZoomUtils.lastZoomState && changingFov) {
            this.field_4015.field_1769.method_3292();
        }
        return fov;
    }

    @Inject(at={@At(value="FIELD", target="Lnet/minecraft/client/options/GameOptions;hudHidden:Z")}, method={"render(FJZ)V"})
    public void injectZoomOverlay(float tickDelta, long startTime, boolean tick, CallbackInfo info) {
        if (OkZoomerConfigPojo.features.zoomOverlay) {
            if (this.field_4015.field_1690.field_1842 && OkZoomerConfigPojo.tweaks.hideZoomOverlay) {
                return;
            }
            RenderSystem.defaultAlphaFunc();
            RenderSystem.enableBlend();
            if (!OkZoomerConfigPojo.features.zoomTransition.equals((Object)OkZoomerConfigPojo.FeaturesGroup.ZoomTransitionOptions.OFF)) {
                if (ZoomUtils.zoomFovMultiplier != 0.0f) {
                    float transparency = class_3532.method_16439((float)tickDelta, (float)ZoomUtils.lastZoomOverlayAlpha, (float)ZoomUtils.zoomOverlayAlpha);
                    this.renderZoomOverlay(transparency);
                }
            } else if (ZoomUtils.zoomState) {
                this.renderZoomOverlay(1.0f);
            }
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableAlphaTest();
            RenderSystem.clear((int)256, (boolean)class_310.field_1703);
        }
    }

    @Unique
    public void renderZoomOverlay(float f) {
        RenderSystem.disableAlphaTest();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.defaultBlendFunc();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)f);
        this.field_4015.method_1531().method_22813(ZOOM_OVERLAY);
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        bufferBuilder.method_1328(7, class_290.field_1585);
        bufferBuilder.method_22912(0.0, (double)this.field_4015.method_22683().method_4502(), -90.0).method_22913(0.0f, 1.0f).method_1344();
        bufferBuilder.method_22912((double)this.field_4015.method_22683().method_4486(), (double)this.field_4015.method_22683().method_4502(), -90.0).method_22913(1.0f, 1.0f).method_1344();
        bufferBuilder.method_22912((double)this.field_4015.method_22683().method_4486(), 0.0, -90.0).method_22913(1.0f, 0.0f).method_1344();
        bufferBuilder.method_22912(0.0, 0.0, -90.0).method_22913(0.0f, 0.0f).method_1344();
        tessellator.method_1350();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.enableAlphaTest();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

