/*
 * Decompiled with CFR 0.152.
 */
package io.github.joaoh1.okzoomer.client.utils;

import io.github.joaoh1.okzoomer.client.config.OkZoomerConfigPojo;
import io.github.joaoh1.okzoomer.client.keybinds.ZoomKeybinds;
import io.github.joaoh1.okzoomer.client.packets.ZoomPackets;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ZoomUtils {
    public static final Logger modLogger = LogManager.getFormatterLogger((String)"Ok Zoomer");
    public static boolean zoomState = false;
    public static boolean lastZoomState = false;
    public static double zoomDivisor = OkZoomerConfigPojo.values.zoomDivisor;
    public static float zoomFovMultiplier = 1.0f;
    public static float lastZoomFovMultiplier = 1.0f;
    public static float zoomOverlayAlpha = 0.0f;
    public static float lastZoomOverlayAlpha = 0.0f;

    public static final void changeZoomDivisor(boolean increase) {
        double lesserChangedZoomDivisor;
        double changedZoomDivisor;
        if (ZoomPackets.disableZoom || ZoomPackets.disableZoomScrolling) {
            return;
        }
        if (increase) {
            changedZoomDivisor = zoomDivisor + OkZoomerConfigPojo.values.scrollStep;
            lesserChangedZoomDivisor = zoomDivisor + OkZoomerConfigPojo.values.lesserScrollStep;
        } else {
            changedZoomDivisor = zoomDivisor - OkZoomerConfigPojo.values.scrollStep;
            lesserChangedZoomDivisor = zoomDivisor - OkZoomerConfigPojo.values.lesserScrollStep;
            lastZoomState = true;
        }
        if (lesserChangedZoomDivisor <= OkZoomerConfigPojo.values.zoomDivisor) {
            changedZoomDivisor = lesserChangedZoomDivisor;
        }
        if (changedZoomDivisor >= OkZoomerConfigPojo.values.minimumZoomDivisor && changedZoomDivisor <= OkZoomerConfigPojo.values.maximumZoomDivisor) {
            zoomDivisor = changedZoomDivisor;
        }
    }

    public static final void resetZoomDivisor() {
        if (ZoomPackets.disableZoom || ZoomPackets.disableZoomScrolling) {
            return;
        }
        zoomDivisor = OkZoomerConfigPojo.values.zoomDivisor;
        lastZoomState = true;
    }

    public static final void unbindConflictingKey(class_310 client, boolean userPrompted) {
        if (ZoomKeybinds.zoomKey.method_1427()) {
            if (client.field_1690.field_1879.method_1427()) {
                if (userPrompted) {
                    modLogger.info("[Ok Zoomer] The \"Save Toolbar Activator\" keybind was occupying C! Unbinding...");
                } else {
                    modLogger.info("[Ok Zoomer] The \"Save Toolbar Activator\" keybind was occupying C! Unbinding... This process won't be repeated until specified in the config.");
                }
                client.field_1690.field_1879.method_1422(class_3675.field_16237);
                client.field_1690.method_1640();
                class_304.method_1426();
            } else {
                modLogger.info("[Ok Zoomer] No conflicts with the \"Save Toolbar Activator\" keybind was found!");
            }
        }
    }

    public static final void updateZoomFovMultiplier() {
        float zoomMultiplier = 1.0f;
        double dividedZoomMultiplier = 1.0 / zoomDivisor;
        if (zoomState) {
            zoomMultiplier = (float)dividedZoomMultiplier;
        }
        lastZoomFovMultiplier = zoomFovMultiplier;
        if (OkZoomerConfigPojo.features.zoomTransition.equals((Object)OkZoomerConfigPojo.FeaturesGroup.ZoomTransitionOptions.SMOOTH)) {
            zoomFovMultiplier = (float)((double)zoomFovMultiplier + (double)(zoomMultiplier - zoomFovMultiplier) * OkZoomerConfigPojo.values.smoothMultiplier);
        } else if (OkZoomerConfigPojo.features.zoomTransition.equals((Object)OkZoomerConfigPojo.FeaturesGroup.ZoomTransitionOptions.LINEAR)) {
            double linearStep = dividedZoomMultiplier;
            if (linearStep < OkZoomerConfigPojo.values.minimumLinearStep) {
                linearStep = OkZoomerConfigPojo.values.minimumLinearStep;
            }
            if (linearStep > OkZoomerConfigPojo.values.maximumLinearStep) {
                linearStep = OkZoomerConfigPojo.values.maximumLinearStep;
            }
            zoomFovMultiplier = class_3532.method_15348((float)zoomFovMultiplier, (float)zoomMultiplier, (float)((float)linearStep));
        }
    }

    public static final void updateZoomOverlayAlpha() {
        float zoomMultiplier = 0.0f;
        if (zoomState) {
            zoomMultiplier = 1.0f;
        }
        lastZoomOverlayAlpha = zoomOverlayAlpha;
        if (OkZoomerConfigPojo.features.zoomTransition.equals((Object)OkZoomerConfigPojo.FeaturesGroup.ZoomTransitionOptions.SMOOTH)) {
            zoomOverlayAlpha = (float)((double)zoomOverlayAlpha + (double)(zoomMultiplier - zoomOverlayAlpha) * OkZoomerConfigPojo.values.smoothMultiplier);
        } else if (OkZoomerConfigPojo.features.zoomTransition.equals((Object)OkZoomerConfigPojo.FeaturesGroup.ZoomTransitionOptions.LINEAR)) {
            double linearStep = 1.0 / zoomDivisor;
            if (linearStep < OkZoomerConfigPojo.values.minimumLinearStep) {
                linearStep = OkZoomerConfigPojo.values.minimumLinearStep;
            }
            if (linearStep > OkZoomerConfigPojo.values.maximumLinearStep) {
                linearStep = OkZoomerConfigPojo.values.maximumLinearStep;
            }
            zoomOverlayAlpha = class_3532.method_15348((float)zoomOverlayAlpha, (float)zoomMultiplier, (float)((float)linearStep));
        }
    }
}

