/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.entity;

import it.unimi.dsi.fastutil.objects.Reference2ByteOpenHashMap;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.logging.Logger;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_1297;
import net.minecraft.class_148;
import net.minecraft.class_1606;
import net.minecraft.class_1695;

public class EntityClassGroup {
    public static final EntityClassGroup BOAT_SHULKER_LIKE_COLLISION;
    public static final EntityClassGroup MINECART_BOAT_LIKE_COLLISION;
    private final Predicate<Class<?>> classFitEvaluator;
    private volatile Reference2ByteOpenHashMap<Class<?>> class2GroupContains = new Reference2ByteOpenHashMap();

    public EntityClassGroup(Predicate<Class<?>> classFitEvaluator) {
        Objects.requireNonNull(classFitEvaluator);
        this.classFitEvaluator = classFitEvaluator;
    }

    public void clear() {
        this.class2GroupContains = new Reference2ByteOpenHashMap();
    }

    public boolean contains(Class<?> entityClass) {
        byte contains = this.class2GroupContains.getOrDefault(entityClass, (byte)2);
        if (contains != 2) {
            return contains == 1;
        }
        return this.testAndAddClass(entityClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean testAndAddClass(Class<?> entityClass) {
        byte contains;
        EntityClassGroup entityClassGroup = this;
        synchronized (entityClassGroup) {
            contains = this.class2GroupContains.getOrDefault(entityClass, (byte)2);
            if (contains != 2) {
                return contains == 1;
            }
            Reference2ByteOpenHashMap newMap = this.class2GroupContains.clone();
            contains = this.classFitEvaluator.test(entityClass) ? (byte)1 : 0;
            newMap.put(entityClass, contains);
            this.class2GroupContains = newMap;
        }
        return contains == 1;
    }

    public static boolean isMethodFromSuperclassOverwritten(Class<?> clazz, Class<?> superclass, String methodName, Class<?> ... methodArgs) {
        while (clazz != null && clazz != superclass && superclass.isAssignableFrom(clazz)) {
            try {
                clazz.getDeclaredMethod(methodName, methodArgs);
                return true;
            }
            catch (NoSuchMethodException e) {
                clazz = clazz.getSuperclass();
            }
            catch (Throwable e) {
                String crashedClass = clazz.getName();
                class_128 crashReport = class_128.method_560((Throwable)e, (String)"Lithium EntityClassGroup analysis");
                class_129 crashReportSection = crashReport.method_562(e.getClass().toString() + " when getting declared methods.");
                crashReportSection.method_578("Analyzed class", (Object)crashedClass);
                crashReportSection.method_578("Analyzed method name", (Object)methodName);
                crashReportSection.method_578("Analyzed method args", methodArgs);
                throw new class_148(crashReport);
            }
        }
        return false;
    }

    static {
        String remapped_method_30948 = FabricLoader.getInstance().getMappingResolver().mapMethodName("intermediary", "net.minecraft.class_1297", "method_30948", "()Z");
        BOAT_SHULKER_LIKE_COLLISION = new EntityClassGroup(entityClass -> EntityClassGroup.isMethodFromSuperclassOverwritten(entityClass, class_1297.class, remapped_method_30948, new Class[0]));
        String remapped_method_30949 = FabricLoader.getInstance().getMappingResolver().mapMethodName("intermediary", "net.minecraft.class_1297", "method_30949", "(Lnet/minecraft/class_1297;)Z");
        MINECART_BOAT_LIKE_COLLISION = new EntityClassGroup(entityClass -> EntityClassGroup.isMethodFromSuperclassOverwritten(entityClass, class_1297.class, remapped_method_30949, class_1297.class));
        if (!MINECART_BOAT_LIKE_COLLISION.contains(class_1695.class)) {
            throw new AssertionError();
        }
        if (!BOAT_SHULKER_LIKE_COLLISION.contains(class_1606.class)) {
            throw new AssertionError();
        }
        if (MINECART_BOAT_LIKE_COLLISION.contains(class_1606.class)) {
            Logger.getLogger("Lithium EntityClassGroup").warning("Either chunk.entity_class_groups is broken or something else gave Shulkers the minecart-like collision behavior.");
        }
        BOAT_SHULKER_LIKE_COLLISION.clear();
        MINECART_BOAT_LIKE_COLLISION.clear();
    }
}

