/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.entity.tracker;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import me.jellysquid.mods.lithium.common.entity.tracker.nearby.NearbyEntityListener;
import me.jellysquid.mods.lithium.common.entity.tracker.nearby.NearbyEntityListenerProvider;
import net.minecraft.class_1309;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_3341;
import net.minecraft.class_4076;

public class EntityTrackerEngine {
    private final Long2ObjectOpenHashMap<TrackedEntityList> sections = new Long2ObjectOpenHashMap();
    private final Reference2ReferenceOpenHashMap<NearbyEntityListener, List<TrackedEntityList>> sectionsByEntity = new Reference2ReferenceOpenHashMap();

    public void onEntityAdded(int x, int y, int z, class_1309 entity) {
        if (this.addEntity(x, y, z, entity) && entity instanceof NearbyEntityListenerProvider) {
            this.addListener(x, y, z, ((NearbyEntityListenerProvider)entity).getListener());
        }
    }

    public void onEntityRemoved(int x, int y, int z, class_1309 entity) {
        if (this.removeEntity(x, y, z, entity) && entity instanceof NearbyEntityListenerProvider) {
            this.removeListener(((NearbyEntityListenerProvider)entity).getListener());
        }
    }

    public void onEntityMoved(int aX, int aY, int aZ, int bX, int bY, int bZ, class_1309 entity) {
        if (this.removeEntity(aX, aY, aZ, entity) && this.addEntity(bX, bY, bZ, entity) && entity instanceof NearbyEntityListenerProvider) {
            this.moveListener(aX, aY, aZ, bX, bY, bZ, ((NearbyEntityListenerProvider)entity).getListener());
        }
    }

    private boolean addEntity(int x, int y, int z, class_1309 entity) {
        return this.getOrCreateList(x, y, z).addTrackedEntity(entity);
    }

    private boolean removeEntity(int x, int y, int z, class_1309 entity) {
        TrackedEntityList list = this.getList(x, y, z);
        if (list == null) {
            return false;
        }
        return list.removeTrackedEntity(entity);
    }

    private void addListener(int x, int y, int z, NearbyEntityListener listener) {
        int r = listener.getChunkRange();
        if (r == 0) {
            return;
        }
        if (this.sectionsByEntity.containsKey((Object)listener)) {
            throw new IllegalStateException(EntityTrackerEngine.errorMessageAlreadyListening(this.sectionsByEntity, listener, class_4076.method_18676((int)x, (int)y, (int)z)));
        }
        int yMin = Math.max(0, y - r);
        int yMax = Math.min(y + r, 15);
        ArrayList<TrackedEntityList> all = new ArrayList<TrackedEntityList>((2 * r + 1) * (yMax - yMin + 1) * (2 * r + 1));
        for (int x2 = x - r; x2 <= x + r; ++x2) {
            for (int y2 = yMin; y2 <= yMax; ++y2) {
                for (int z2 = z - r; z2 <= z + r; ++z2) {
                    TrackedEntityList list = this.getOrCreateList(x2, y2, z2);
                    list.addListener(listener);
                    all.add(list);
                }
            }
        }
        this.sectionsByEntity.put((Object)listener, all);
    }

    private void removeListener(NearbyEntityListener listener) {
        int r = listener.getChunkRange();
        if (r == 0) {
            return;
        }
        List all = (List)this.sectionsByEntity.remove((Object)listener);
        if (all != null) {
            for (TrackedEntityList list : all) {
                list.removeListener(listener);
            }
        } else {
            throw new IllegalArgumentException("Entity listener not tracked:" + listener.toString());
        }
    }

    private void moveListener(int aX, int aY, int aZ, int bX, int bY, int bZ, NearbyEntityListener listener) {
        int radius = listener.getChunkRange();
        if (radius == 0) {
            return;
        }
        class_3341 before = new class_3341(aX - radius, aY - radius, aZ - radius, aX + radius, aY + radius, aZ + radius);
        class_3341 after = new class_3341(aX - radius, aY - radius, aZ - radius, bX + radius, bY + radius, bZ + radius);
        class_3341 merged = new class_3341(before);
        merged.method_14668(after);
        class_2338.class_2339 pos = new class_2338.class_2339();
        for (int x = merged.field_14381; x <= merged.field_14378; ++x) {
            for (int y = merged.field_14380; y <= merged.field_14377; ++y) {
                for (int z = merged.field_14379; z <= merged.field_14376; ++z) {
                    TrackedEntityList list;
                    pos.method_10103(x, y, z);
                    boolean leaving = before.method_14662((class_2382)pos);
                    boolean entering = after.method_14662((class_2382)pos);
                    if (leaving == entering) continue;
                    if (leaving) {
                        list = this.getList(x, y, z);
                        if (list == null) {
                            throw new IllegalStateException("Expected there to be a listener list while moving entity but there was none");
                        }
                        list.removeListener(listener);
                        continue;
                    }
                    list = this.getOrCreateList(x, y, z);
                    list.addListener(listener);
                }
            }
        }
    }

    private TrackedEntityList getOrCreateList(int x, int y, int z) {
        return (TrackedEntityList)this.sections.computeIfAbsent(EntityTrackerEngine.encode(x, y, z), x$0 -> new TrackedEntityList(x$0));
    }

    private TrackedEntityList getList(int x, int y, int z) {
        return (TrackedEntityList)this.sections.get(EntityTrackerEngine.encode(x, y, z));
    }

    private static long encode(int x, int y, int z) {
        return class_4076.method_18685((int)x, (int)y, (int)z);
    }

    private static class_4076 decode(long xyz) {
        return class_4076.method_18677((long)xyz);
    }

    private static String errorMessageAlreadyListening(Reference2ReferenceOpenHashMap<NearbyEntityListener, List<TrackedEntityList>> sectionsByEntity, NearbyEntityListener listener, class_4076 newLocation) {
        StringBuilder builder = new StringBuilder();
        builder.append("Adding Entity listener a second time: ").append(listener.toString());
        builder.append("\n");
        builder.append(" wants to listen at: ").append(newLocation.toString());
        builder.append(" with cube radius: ").append(listener.getChunkRange());
        builder.append("\n");
        builder.append(" but was already listening at chunk sections: ");
        String[] comma = new String[]{""};
        if (sectionsByEntity.get((Object)listener) == null) {
            builder.append("null");
        } else {
            ((List)sectionsByEntity.get((Object)listener)).forEach(a -> {
                builder.append(comma[0]);
                builder.append(EntityTrackerEngine.decode(((TrackedEntityList)a).key).toString());
                comma[0] = ", ";
            });
        }
        return builder.toString();
    }

    private class TrackedEntityList {
        private final Set<class_1309> entities = new ReferenceOpenHashSet();
        private final Set<NearbyEntityListener> listeners = new ReferenceOpenHashSet();
        private final long key;

        private TrackedEntityList(long key) {
            this.key = key;
        }

        public void addListener(NearbyEntityListener listener) {
            for (class_1309 entity : this.entities) {
                listener.onEntityEnteredRange(entity);
            }
            this.listeners.add(listener);
        }

        public void removeListener(NearbyEntityListener listener) {
            if (this.listeners.remove(listener)) {
                for (class_1309 entity : this.entities) {
                    listener.onEntityLeftRange(entity);
                }
                this.checkEmpty();
            }
        }

        public boolean addTrackedEntity(class_1309 entity) {
            for (NearbyEntityListener listener : this.listeners) {
                listener.onEntityEnteredRange(entity);
            }
            return this.entities.add(entity);
        }

        public boolean removeTrackedEntity(class_1309 entity) {
            boolean ret = this.entities.remove(entity);
            if (ret) {
                for (NearbyEntityListener listener : this.listeners) {
                    listener.onEntityLeftRange(entity);
                }
                this.checkEmpty();
            }
            return ret;
        }

        private void checkEmpty() {
            if (this.entities.isEmpty() && this.listeners.isEmpty()) {
                EntityTrackerEngine.this.sections.remove(this.key);
            }
        }
    }
}

