/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.api;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import virtuoel.pehkui.util.JsonConfigHandler;

public class PehkuiConfig {
    private static final Collection<Consumer<JsonObject>> DEFAULT_VALUES = new ArrayList<Consumer<JsonObject>>();
    public static final Common COMMON = new Common();
    public static final Client CLIENT = new Client();
    public static final Server SERVER = new Server();
    private static final Supplier<JsonObject> HANDLER = PehkuiConfig.createConfig();
    private static final JsonObject DATA = HANDLER.get();

    private static Supplier<JsonObject> createConfig() {
        return new JsonConfigHandler("pehkui", "config.json", PehkuiConfig::createDefaultConfig);
    }

    private static JsonObject createDefaultConfig() {
        JsonObject config = new JsonObject();
        for (Consumer<JsonObject> value : DEFAULT_VALUES) {
            value.accept(config);
        }
        return config;
    }

    private static Supplier<Double> doubleConfig(String config, double defaultValue) {
        return PehkuiConfig.numberConfig(config, Number::doubleValue, defaultValue);
    }

    private static <T extends Number> Supplier<T> numberConfig(String config, Function<Number, T> mapper, T defaultValue) {
        DEFAULT_VALUES.add(c -> c.addProperty(config, defaultValue));
        return () -> Optional.ofNullable(DATA.get(config)).filter(JsonElement::isJsonPrimitive).map(JsonElement::getAsJsonPrimitive).filter(JsonPrimitive::isNumber).map(JsonPrimitive::getAsNumber).map(mapper).orElse(defaultValue);
    }

    private static Supplier<Boolean> booleanConfig(String config, boolean defaultValue) {
        DEFAULT_VALUES.add(c -> c.addProperty(config, Boolean.valueOf(defaultValue)));
        return () -> Optional.ofNullable(DATA.get(config)).filter(JsonElement::isJsonPrimitive).map(JsonElement::getAsJsonPrimitive).filter(JsonPrimitive::isBoolean).map(JsonPrimitive::getAsBoolean).orElse(defaultValue);
    }

    private static Supplier<List<String>> stringListConfig(String config) {
        return PehkuiConfig.listConfig(config, JsonElement::getAsString);
    }

    private static <T> Supplier<List<T>> listConfig(String config, Function<JsonElement, T> mapper) {
        DEFAULT_VALUES.add(c -> c.add(config, (JsonElement)new JsonArray()));
        return () -> Optional.ofNullable(DATA.get(config)).filter(JsonElement::isJsonArray).map(JsonElement::getAsJsonArray).map(Iterable::spliterator).map(a -> StreamSupport.stream(a, false)).map(s -> s.map(mapper).collect(Collectors.toList())).orElseGet(ArrayList::new);
    }

    static /* synthetic */ Supplier access$000(String x0, boolean x1) {
        return PehkuiConfig.booleanConfig(x0, x1);
    }

    static /* synthetic */ Supplier access$100(String x0) {
        return PehkuiConfig.stringListConfig(x0);
    }

    static /* synthetic */ Supplier access$200(String x0, double x1) {
        return PehkuiConfig.doubleConfig(x0, x1);
    }

    public static class Common {
        public final Supplier<Boolean> scaledFallDamage = PehkuiConfig.access$000("scaledFallDamage", true);
        public final Supplier<Boolean> scaledMotion = PehkuiConfig.access$000("scaledMotion", true);
        public final Supplier<Boolean> scaledReach = PehkuiConfig.access$000("scaledReach", true);
        public final Supplier<Boolean> scaledAttack = PehkuiConfig.access$000("scaledAttack", true);
        public final Supplier<Boolean> scaledDefense = PehkuiConfig.access$000("scaledDefense", true);
        public final Supplier<Boolean> scaledHealth = PehkuiConfig.access$000("scaledHealth", true);
        public final Supplier<Boolean> scaledItemDrops = PehkuiConfig.access$000("scaledItemDrops", true);
        public final Supplier<Boolean> scaledProjectiles = PehkuiConfig.access$000("scaledProjectiles", true);
        public final Supplier<Boolean> scaledExplosions = PehkuiConfig.access$000("scaledExplosions", true);
        public final Supplier<Boolean> keepAllScalesOnRespawn = PehkuiConfig.access$000("keepAllScalesOnRespawn", false);
        public final Supplier<List<String>> scalesKeptOnRespawn = PehkuiConfig.access$100("scalesKeptOnRespawn");
        public final Supplier<Boolean> accurateNetherPortals = PehkuiConfig.access$000("accurateNetherPortals", true);
        public final Supplier<Double> largeScaleCollisionThreshold = PehkuiConfig.access$200("largeScaleCollisionThreshold", 26.0);
        public final Supplier<Boolean> enableDebugCommands = PehkuiConfig.access$000("enableDebugCommands", false);

        Common() {
        }
    }

    public static class Client {
        public final Supplier<Double> minimumCameraDepth = PehkuiConfig.access$200("minimumCameraDepth", 0.0);

        Client() {
        }
    }

    public static class Server {
        Server() {
        }
    }
}

