/*
 * Decompiled with CFR 0.152.
 */
package ru.bclib.registry;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import ru.bclib.BCLib;

public abstract class BaseRegistry<T> {
    private static final List<BaseRegistry<?>> REGISTRIES = Lists.newArrayList();
    private static final Map<String, List<class_1792>> MOD_BLOCKS = Maps.newHashMap();
    private static final Map<String, List<class_1792>> MOD_ITEMS = Maps.newHashMap();
    protected final class_1761 creativeTab;

    public static Map<String, List<class_1792>> getRegisteredBlocks() {
        return MOD_BLOCKS;
    }

    public static Map<String, List<class_1792>> getRegisteredItems() {
        return MOD_ITEMS;
    }

    public static List<class_1792> getModBlocks(String modId) {
        if (MOD_BLOCKS.containsKey(modId)) {
            return MOD_BLOCKS.get(modId);
        }
        ArrayList modBlocks = Lists.newArrayList();
        MOD_BLOCKS.put(modId, modBlocks);
        return modBlocks;
    }

    public static List<class_1792> getModItems(String modId) {
        if (MOD_ITEMS.containsKey(modId)) {
            return MOD_ITEMS.get(modId);
        }
        ArrayList modBlocks = Lists.newArrayList();
        MOD_ITEMS.put(modId, modBlocks);
        return modBlocks;
    }

    public static void register() {
        REGISTRIES.forEach(BaseRegistry::registerInternal);
    }

    protected BaseRegistry(class_1761 creativeTab) {
        this.creativeTab = creativeTab;
        REGISTRIES.add(this);
    }

    public T register(String name, T obj) {
        return this.register(this.createModId(name), obj);
    }

    public abstract T register(class_2960 var1, T var2);

    public class_2960 createModId(String name) {
        return BCLib.makeID(name);
    }

    public void registerItem(class_2960 id, class_1792 item, List<class_1792> registry) {
        if (item != class_1802.field_8162) {
            class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)id, (Object)item);
            registry.add(item);
        }
    }

    public FabricItemSettings makeItemSettings() {
        FabricItemSettings properties = new FabricItemSettings();
        return (FabricItemSettings)properties.method_7892(this.creativeTab);
    }

    private void registerInternal() {
    }
}

