/*
 * Decompiled with CFR 0.152.
 */
package me.benfah.doorsofinfinity.utils;

import com.qouteall.immersive_portals.my_util.IntBox;
import java.util.Comparator;
import java.util.IntSummaryStatistics;
import java.util.Optional;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3545;

public class BoxUtils {
    public static class_238 getBoxInclusive(class_2338 pos1, class_2338 pos2) {
        return new class_238(new class_243((double)pos1.method_10263(), (double)pos1.method_10264(), (double)pos1.method_10260()), new class_243((double)(pos2.method_10263() + 1), (double)(pos2.method_10264() + 1), (double)(pos2.method_10260() + 1)));
    }

    public static class_3545<class_2338, class_2338> getAnchors(IntBox box) {
        class_2338 lowAnchorPos = (class_2338)box.stream().min(Comparator.comparingInt(class_2382::method_10263).thenComparingInt(class_2382::method_10264).thenComparingInt(class_2382::method_10260)).get();
        class_2338 highAnchorPos = (class_2338)box.stream().min(Comparator.comparingInt(class_2382::method_10263).thenComparingInt(class_2382::method_10264).thenComparingInt(class_2382::method_10260)).get();
        return new class_3545((Object)lowAnchorPos, (Object)highAnchorPos);
    }

    public static class_2487 vecToTag(class_2382 vec3i) {
        class_2487 tag = new class_2487();
        tag.method_10569("PosX", vec3i.method_10263());
        tag.method_10569("PosY", vec3i.method_10264());
        tag.method_10569("PosZ", vec3i.method_10260());
        return tag;
    }

    public static class_2382 vecFromTag(class_2487 vec3i) {
        int x = vec3i.method_10550("PosX");
        int y = vec3i.method_10550("PosY");
        int z = vec3i.method_10550("PosZ");
        return new class_2382(x, y, z);
    }

    public static PlaneInfo getPlaneFromIntBox(IntBox box, class_2350 direction) {
        class_2350 rightDirection = class_2350.method_10139((int)BoxUtils.getAbsoluteHorizontal(direction.method_10161() - 1));
        class_2382 axisH = class_2350.field_11036.method_10163();
        class_2382 axisW = rightDirection.method_10163();
        class_2382 axisL = direction.method_10163();
        int height = box.stream().mapToInt(class_2382::method_10264).max().getAsInt() - box.stream().mapToInt(class_2382::method_10264).min().getAsInt() + 1;
        IntSummaryStatistics widthStream = box.stream().mapToInt(pos -> rightDirection.method_10166().method_10173(pos.method_10263(), pos.method_10264(), pos.method_10260())).summaryStatistics();
        int width = widthStream.getMax() - widthStream.getMin() + 1;
        int x = box.stream().map(class_2382::method_10263).min((i1, i2) -> axisW.method_10263() == 0 ? Integer.compare(i1 * axisL.method_10263(), i2 * axisL.method_10263()) : Integer.compare(i1 * axisW.method_10263(), i2 * axisW.method_10263())).get();
        int y = box.stream().mapToInt(class_2382::method_10264).min().getAsInt();
        int z = box.stream().map(class_2382::method_10260).min((i1, i2) -> axisW.method_10260() == 0 ? Integer.compare(i1 * axisL.method_10260(), i2 * axisL.method_10260()) : Integer.compare(i1 * axisW.method_10260(), i2 * axisW.method_10260())).get();
        return new PlaneInfo(axisW, axisH, width, height, new class_2338(x, y, z));
    }

    public static <T extends Comparable<T>> boolean hasSamePropertyValue(class_2769<T> property, class_2680 toCompare, T value) {
        Optional<class_2769> optional = toCompare.method_28501().stream().filter(compProp -> compProp.equals((Object)property)).findAny();
        if (optional.isPresent()) {
            return optional.get().equals(property) && toCompare.method_11654(property).equals(value);
        }
        return false;
    }

    public static int getAbsoluteHorizontal(int horizontal) {
        return horizontal < 0 ? horizontal + 4 : horizontal;
    }

    public static class PlaneInfo {
        public class_2382 axisW;
        public class_2382 axisH;
        public int width;
        public int height;
        public class_2338 pos;

        public PlaneInfo(class_2382 axisW, class_2382 axisH, int width, int height, class_2338 pos) {
            this.axisW = axisW;
            this.axisH = axisH;
            this.width = width;
            this.height = height;
            this.pos = pos;
        }

        public PlaneInfo(class_2487 tag) {
            this.axisW = BoxUtils.vecFromTag(tag.method_10562("AxisW"));
            this.axisH = BoxUtils.vecFromTag(tag.method_10562("AxisH"));
            this.width = tag.method_10550("Width");
            this.height = tag.method_10550("Height");
            this.pos = new class_2338(BoxUtils.vecFromTag(tag.method_10562("StartPos")));
        }

        public class_2487 toCompound(class_2487 tag) {
            tag.method_10566("AxisW", (class_2520)BoxUtils.vecToTag(this.axisW));
            tag.method_10566("AxisH", (class_2520)BoxUtils.vecToTag(this.axisH));
            tag.method_10569("Width", this.width);
            tag.method_10569("Height", this.height);
            tag.method_10566("StartPos", (class_2520)BoxUtils.vecToTag((class_2382)this.pos));
            return tag;
        }

        public boolean equals(Object obj) {
            if (obj instanceof PlaneInfo) {
                PlaneInfo toCompare = (PlaneInfo)obj;
                return toCompare.height == this.height && toCompare.width == this.width;
            }
            return false;
        }
    }
}

