/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.world.carver.controller;

import com.yungnickyoung.minecraft.bettercaves.BetterCaves;
import com.yungnickyoung.minecraft.bettercaves.config.util.ConfigHolder;
import com.yungnickyoung.minecraft.bettercaves.enums.CaveType;
import com.yungnickyoung.minecraft.bettercaves.util.BetterCavesUtils;
import com.yungnickyoung.minecraft.bettercaves.world.carver.CarverNoiseRange;
import com.yungnickyoung.minecraft.bettercaves.world.carver.ICarver;
import com.yungnickyoung.minecraft.bettercaves.world.carver.cave.CaveCarver;
import com.yungnickyoung.minecraft.bettercaves.world.carver.cave.CaveCarverBuilder;
import com.yungnickyoung.minecraft.bettercaves.world.carver.vanilla.VanillaCaveCarver;
import com.yungnickyoung.minecraft.bettercaves.world.carver.vanilla.VanillaCaveCarverBuilder;
import com.yungnickyoung.minecraft.yungsapi.noise.FastNoise;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_5281;

public class CaveCarverController {
    private class_5281 world;
    private VanillaCaveCarver surfaceCaveCarver;
    private FastNoise caveRegionSampler;
    private List<CarverNoiseRange> noiseRanges = new ArrayList<CarverNoiseRange>();
    private boolean isDebugViewEnabled;
    private boolean isOverrideSurfaceDetectionEnabled;
    private boolean isSurfaceCavesEnabled;
    private boolean isFloodedUndergroundEnabled;

    public CaveCarverController(class_5281 worldIn, ConfigHolder config) {
        this.world = worldIn;
        this.isDebugViewEnabled = config.debugVisualizer.get();
        this.isOverrideSurfaceDetectionEnabled = config.overrideSurfaceDetection.get();
        this.isSurfaceCavesEnabled = config.isSurfaceCavesEnabled.get();
        this.isFloodedUndergroundEnabled = config.enableFloodedUnderground.get();
        this.surfaceCaveCarver = new VanillaCaveCarverBuilder().bottomY(config.surfaceCaveBottom.get()).topY(config.surfaceCaveTop.get()).density(config.surfaceCaveDensity.get()).liquidAltitude(config.liquidAltitude.get()).replaceGravel(config.replaceFloatingGravel.get()).floodedUnderground(config.enableFloodedUnderground.get()).debugVisualizerEnabled(config.debugVisualizer.get()).debugVisualizerBlock(class_2246.field_10234.method_9564()).build();
        float caveRegionSize = this.calcCaveRegionSize(config.caveRegionSize.get(), config.caveRegionCustomSize.get().floatValue());
        this.caveRegionSampler = new FastNoise();
        this.caveRegionSampler.SetSeed((int)worldIn.method_8412() + 222);
        this.caveRegionSampler.SetFrequency(caveRegionSize);
        this.caveRegionSampler.SetNoiseType(FastNoise.NoiseType.Cellular);
        this.caveRegionSampler.SetCellularDistanceFunction(FastNoise.CellularDistanceFunction.Natural);
        ArrayList<ICarver> carvers = new ArrayList<ICarver>();
        carvers.add(new CaveCarverBuilder(worldIn.method_8412()).ofTypeFromConfig(CaveType.CUBIC, config).debugVisualizerBlock(class_2246.field_10161.method_9564()).build());
        carvers.add(new CaveCarverBuilder(worldIn.method_8412()).ofTypeFromConfig(CaveType.SIMPLEX, config).debugVisualizerBlock(class_2246.field_10445.method_9564()).build());
        carvers.add(new VanillaCaveCarverBuilder().bottomY(config.vanillaCaveBottom.get()).topY(config.vanillaCaveTop.get()).density(config.vanillaCaveDensity.get()).priority(config.vanillaCavePriority.get()).liquidAltitude(config.liquidAltitude.get()).replaceGravel(config.replaceFloatingGravel.get()).floodedUnderground(config.enableFloodedUnderground.get()).debugVisualizerEnabled(config.debugVisualizer.get()).debugVisualizerBlock(class_2246.field_10104.method_9564()).build());
        carvers.removeIf(carver -> carver.getPriority() == 0);
        float maxPossibleNoiseThreshold = config.caveSpawnChance.get().floatValue() * 0.01f * 2.0f - 1.0f;
        int totalPriority = carvers.stream().map(ICarver::getPriority).reduce(0, Integer::sum);
        float totalRangeLength = maxPossibleNoiseThreshold - -1.0f;
        float currNoise = -1.0f;
        BetterCaves.LOGGER.debug("CAVE INFORMATION");
        BetterCaves.LOGGER.debug("--> MAX POSSIBLE THRESHOLD: " + maxPossibleNoiseThreshold);
        BetterCaves.LOGGER.debug("--> TOTAL PRIORITY: " + totalPriority);
        BetterCaves.LOGGER.debug("--> TOTAL RANGE LENGTH: " + totalRangeLength);
        for (ICarver carver2 : carvers) {
            BetterCaves.LOGGER.debug("--> CARVER");
            float noiseRangeLength = (float)carver2.getPriority() / (float)totalPriority * totalRangeLength;
            float rangeTop = currNoise + noiseRangeLength;
            CarverNoiseRange range = new CarverNoiseRange(currNoise, rangeTop, carver2);
            currNoise = rangeTop;
            this.noiseRanges.add(range);
            BetterCaves.LOGGER.debug("    --> RANGE FOUND: " + range);
        }
    }

    public void carveChunk(class_2791 chunk, int chunkX, int chunkZ, int[][] surfaceAltitudes, class_2680[][] liquidBlocks, Function<class_2338, class_1959> biomePos, BitSet airCarvingMask, BitSet liquidCarvingMask) {
        if (this.noiseRanges.size() == 0 && !this.isSurfaceCavesEnabled) {
            return;
        }
        class_2338.class_2339 mutablePos = new class_2338.class_2339();
        boolean shouldCarveVanillaCaves = false;
        boolean[][] validPositions = new boolean[16][16];
        for (int subX = 0; subX < 4; ++subX) {
            for (int subZ = 0; subZ < 4; ++subZ) {
                int startX = subX * 4;
                int startZ = subZ * 4;
                int endX = startX + 4 - 1;
                int endZ = startZ + 4 - 1;
                class_2338 startPos = new class_2338(chunkX * 16 + startX, 1, chunkZ * 16 + startZ);
                class_2338 endPos = new class_2338(chunkX * 16 + endX, 1, chunkZ * 16 + endZ);
                this.noiseRanges.forEach(range -> range.setNoiseCube(null));
                int maxHeight = 0;
                if (!this.isOverrideSurfaceDetectionEnabled) {
                    for (int x = startX; x < endX; ++x) {
                        for (int z = startZ; z < endZ; ++z) {
                            maxHeight = Math.max(maxHeight, surfaceAltitudes[x][z]);
                        }
                    }
                    for (CarverNoiseRange range2 : this.noiseRanges) {
                        maxHeight = Math.max(maxHeight, range2.getCarver().getTopY());
                    }
                }
                for (int offsetX = 0; offsetX < 4; ++offsetX) {
                    block6: for (int offsetZ = 0; offsetZ < 4; ++offsetZ) {
                        boolean flooded;
                        int localX = startX + offsetX;
                        int localZ = startZ + offsetZ;
                        class_2338 colPos = new class_2338(chunkX * 16 + localX, 1, chunkZ * 16 + localZ);
                        boolean bl = flooded = this.isFloodedUndergroundEnabled && !this.isDebugViewEnabled && biomePos.apply(colPos).method_8688() == class_1959.class_1961.field_9367;
                        if (flooded && (BetterCavesUtils.isPosInWorld((class_2338)mutablePos.method_10101((class_2382)colPos).method_10098(class_2350.field_11034), this.world) && biomePos.apply((class_2338)mutablePos.method_10101((class_2382)colPos).method_10098(class_2350.field_11034)).method_8688() != class_1959.class_1961.field_9367 || BetterCavesUtils.isPosInWorld((class_2338)mutablePos.method_10101((class_2382)colPos).method_10098(class_2350.field_11039), this.world) && biomePos.apply((class_2338)mutablePos.method_10101((class_2382)colPos).method_10098(class_2350.field_11039)).method_8688() != class_1959.class_1961.field_9367 || BetterCavesUtils.isPosInWorld((class_2338)mutablePos.method_10101((class_2382)colPos).method_10098(class_2350.field_11043), this.world) && biomePos.apply((class_2338)mutablePos.method_10101((class_2382)colPos).method_10098(class_2350.field_11043)).method_8688() != class_1959.class_1961.field_9367 || BetterCavesUtils.isPosInWorld((class_2338)mutablePos.method_10101((class_2382)colPos).method_10098(class_2350.field_11035), this.world) && biomePos.apply((class_2338)mutablePos.method_10101((class_2382)colPos).method_10098(class_2350.field_11035)).method_8688() != class_1959.class_1961.field_9367)) continue;
                        int surfaceAltitude = surfaceAltitudes[localX][localZ];
                        class_2680 liquidBlock = liquidBlocks[localX][localZ];
                        float caveRegionNoise = this.caveRegionSampler.GetNoise((float)colPos.method_10263(), (float)colPos.method_10260());
                        for (CarverNoiseRange range3 : this.noiseRanges) {
                            if (!range3.contains(caveRegionNoise)) continue;
                            if (range3.getCarver() instanceof CaveCarver) {
                                CaveCarver carver = (CaveCarver)range3.getCarver();
                                int bottomY = carver.getBottomY();
                                int topY = Math.min(surfaceAltitude, carver.getTopY());
                                if (this.isOverrideSurfaceDetectionEnabled) {
                                    topY = carver.getTopY();
                                    maxHeight = carver.getTopY();
                                }
                                if (this.isDebugViewEnabled) {
                                    topY = 128;
                                    maxHeight = 128;
                                }
                                if (range3.getNoiseCube() == null) {
                                    range3.setNoiseCube(carver.getNoiseGen().interpolateNoiseCube(startPos, endPos, bottomY, maxHeight));
                                }
                                double[][] noiseColumn = range3.getNoiseCube()[offsetX][offsetZ];
                                carver.carveColumn(chunk, colPos, topY, noiseColumn, liquidBlock, flooded, flooded ? liquidCarvingMask : airCarvingMask);
                                continue block6;
                            }
                            if (!(range3.getCarver() instanceof VanillaCaveCarver)) continue;
                            validPositions[localX][localZ] = true;
                            shouldCarveVanillaCaves = true;
                        }
                    }
                }
            }
        }
        if (shouldCarveVanillaCaves) {
            VanillaCaveCarver carver = null;
            for (CarverNoiseRange range4 : this.noiseRanges) {
                if (!(range4.getCarver() instanceof VanillaCaveCarver)) continue;
                carver = (VanillaCaveCarver)range4.getCarver();
                break;
            }
            if (carver != null) {
                carver.generate(this.world, chunkX, chunkZ, chunk, true, liquidBlocks, biomePos, validPositions, airCarvingMask, liquidCarvingMask);
            }
        }
        if (this.isSurfaceCavesEnabled) {
            this.surfaceCaveCarver.generate(this.world, chunkX, chunkZ, chunk, false, liquidBlocks, biomePos, airCarvingMask, liquidCarvingMask);
        }
    }

    private float calcCaveRegionSize(String caveRegionSize, float caveRegionCustomSize) {
        switch (caveRegionSize.toLowerCase()) {
            case "small": {
                return 0.008f;
            }
            case "large": {
                return 0.0032f;
            }
            case "extralarge": {
                return 0.001f;
            }
            case "custom": {
                return caveRegionCustomSize;
            }
        }
        return 0.005f;
    }

    public void setWorld(class_5281 worldIn) {
        this.world = worldIn;
        this.surfaceCaveCarver.setWorld(worldIn);
        for (CarverNoiseRange range : this.noiseRanges) {
            if (!(range.getCarver() instanceof VanillaCaveCarver)) continue;
            ((VanillaCaveCarver)range.getCarver()).setWorld(worldIn);
            break;
        }
    }
}

