/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettercaves.world.carver.controller;

import com.yungnickyoung.minecraft.bettercaves.BetterCaves;
import com.yungnickyoung.minecraft.bettercaves.config.ConfigLoader;
import com.yungnickyoung.minecraft.bettercaves.config.util.ConfigHolder;
import com.yungnickyoung.minecraft.bettercaves.world.carver.bedrock.BedrockFlattener;
import com.yungnickyoung.minecraft.bettercaves.world.carver.controller.CaveCarverController;
import com.yungnickyoung.minecraft.bettercaves.world.carver.controller.CavernCarverController;
import com.yungnickyoung.minecraft.bettercaves.world.carver.controller.LiquidRegionController;
import com.yungnickyoung.minecraft.bettercaves.world.carver.controller.RavineCarverController;
import java.util.BitSet;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2902;
import net.minecraft.class_5281;

public class MasterController {
    private class_5281 world;
    public long seed = 0L;
    public ConfigHolder configHolder;
    private CaveCarverController caveCarverController;
    private CavernCarverController cavernCarverController;
    private RavineCarverController ravineCarverController;
    private LiquidRegionController liquidRegionController;

    public boolean carveRegion(class_2791 chunkIn, Function<class_2338, class_1959> biomePos, int chunkX, int chunkZ, BitSet airCarvingMask, BitSet liquidCarvingMask) {
        if (this.configHolder.flattenBedrock.get().booleanValue()) {
            BedrockFlattener.flattenBedrock(chunkIn, biomePos, this.configHolder.bedrockWidth.get());
        }
        int[][] surfaceAltitudes = new int[16][16];
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                surfaceAltitudes[x][z] = this.configHolder.overrideSurfaceDetection.get() != false ? 1 : Math.min(chunkIn.method_12005(class_2902.class_2903.field_13194, x, z), chunkIn.method_12005(class_2902.class_2903.field_13195, x, z));
            }
        }
        class_2680[][] liquidBlocks = this.liquidRegionController.getLiquidBlocksForChunk(chunkX, chunkZ);
        this.ravineCarverController.carveChunk(chunkIn, chunkX, chunkZ, liquidBlocks, biomePos, airCarvingMask, liquidCarvingMask);
        this.caveCarverController.carveChunk(chunkIn, chunkX, chunkZ, surfaceAltitudes, liquidBlocks, biomePos, airCarvingMask, liquidCarvingMask);
        this.cavernCarverController.carveChunk(chunkIn, chunkX, chunkZ, surfaceAltitudes, liquidBlocks, biomePos, airCarvingMask, liquidCarvingMask);
        return true;
    }

    public void initialize(class_5281 worldIn) {
        this.world = worldIn;
        this.seed = worldIn.method_8412();
        String dimensionName = "";
        try {
            dimensionName = Objects.requireNonNull(this.world.method_8410().method_27983().method_29177()).toString();
        }
        catch (NullPointerException e) {
            BetterCaves.LOGGER.error("ERROR: Unable to get dimension name! This could be a problem...");
        }
        this.configHolder = dimensionName.equals("") ? new ConfigHolder() : ConfigLoader.loadConfigFromFileForDimension(dimensionName);
        this.caveCarverController = new CaveCarverController(worldIn, this.configHolder);
        this.cavernCarverController = new CavernCarverController(worldIn, this.configHolder);
        this.liquidRegionController = new LiquidRegionController(worldIn, this.configHolder);
        this.ravineCarverController = new RavineCarverController(worldIn, this.configHolder);
        BetterCaves.LOGGER.debug(String.format("BETTER CAVES WORLD CARVER INITIALIZED WITH SEED %d IN %s", this.seed, dimensionName));
    }

    public void setWorld(class_5281 worldIn) {
        this.world = worldIn;
        this.caveCarverController.setWorld(worldIn);
        this.cavernCarverController.setWorld(worldIn);
        this.liquidRegionController.setWorld(worldIn);
        this.ravineCarverController.setWorld(worldIn);
    }

    public long getSeed() {
        return this.seed;
    }
}

