/*
 * Decompiled with CFR 0.152.
 */
package zabi.minecraft.extraalchemy.utils;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;

public abstract class DelayedConsumer<T> {
    private List<Consumer<T>> tasks = Lists.newArrayList();
    private T key = null;

    public void consumeWhenReady(Consumer<T> task) {
        if (this.key == null) {
            this.tasks.add(task);
        } else {
            task.accept(this.key);
        }
    }

    public void keyReady(T key) {
        this.key = key;
        Iterator<Consumer<T>> it = this.tasks.iterator();
        while (it.hasNext()) {
            Consumer<T> task = it.next();
            it.remove();
            task.accept(key);
        }
    }
}

