/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.biome;

import fuzs.puzzleslib.api.biome.v1.BiomeLoadingContext;
import fuzs.puzzleslib.proxy.Proxy;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.WorldData;

public class BiomeLoadingContextForge
implements BiomeLoadingContext {
    private final RegistryAccess registryAccess;
    private final PrimaryLevelData levelData;
    private final ResourceKey<Biome> resourceKey;
    private final Biome biome;
    private final Holder<Biome> holder;

    private BiomeLoadingContextForge(RegistryAccess registryAccess, PrimaryLevelData levelData, ResourceKey<Biome> resourceKey, Biome biome, Holder<Biome> holder) {
        this.registryAccess = registryAccess;
        this.levelData = levelData;
        this.resourceKey = resourceKey;
        this.biome = biome;
        this.holder = holder;
    }

    public static BiomeLoadingContext create(Holder<Biome> holder) {
        MinecraftServer server = Proxy.INSTANCE.getGameServer();
        WorldData worldData = server.m_129910_();
        if (!(worldData instanceof PrimaryLevelData)) {
            throw new RuntimeException("Incompatible SaveProperties passed to MinecraftServer: " + worldData);
        }
        PrimaryLevelData primaryLevelData = (PrimaryLevelData)worldData;
        ResourceKey resourceKey = (ResourceKey)holder.m_203543_().orElseThrow();
        return new BiomeLoadingContextForge((RegistryAccess)server.m_206579_(), primaryLevelData, (ResourceKey<Biome>)resourceKey, (Biome)holder.m_203334_(), holder);
    }

    @Override
    public ResourceKey<Biome> getResourceKey() {
        return this.resourceKey;
    }

    @Override
    public Biome getBiome() {
        return this.biome;
    }

    @Override
    public Holder<Biome> holder() {
        return this.holder;
    }

    @Override
    public Optional<ResourceKey<ConfiguredFeature<?, ?>>> getFeatureKey(ConfiguredFeature<?, ?> configuredFeature) {
        Registry registry = this.registryAccess.m_175515_(Registry.f_122881_);
        return registry.m_7854_(configuredFeature);
    }

    @Override
    public Optional<ResourceKey<PlacedFeature>> getPlacedFeatureKey(PlacedFeature placedFeature) {
        Registry registry = this.registryAccess.m_175515_(Registry.f_194567_);
        return registry.m_7854_((Object)placedFeature);
    }

    @Override
    public boolean validForStructure(ResourceKey<Structure> key) {
        Structure instance = (Structure)this.registryAccess.m_175515_(Registry.f_235725_).m_6246_(key);
        if (instance == null) {
            return false;
        }
        return instance.m_226559_().m_203333_(this.holder());
    }

    @Override
    public Optional<ResourceKey<Structure>> getStructureKey(Structure structure) {
        Registry registry = this.registryAccess.m_175515_(Registry.f_235725_);
        return registry.m_7854_((Object)structure);
    }

    @Override
    public boolean canGenerateIn(ResourceKey<LevelStem> dimensionKey) {
        LevelStem dimension = (LevelStem)this.levelData.m_5961_().m_204655_().m_6246_(dimensionKey);
        if (dimension == null) {
            return false;
        }
        return dimension.m_63990_().m_62218_().m_207840_().stream().anyMatch(entry -> entry.m_203334_() == this.biome);
    }

    @Override
    public boolean is(TagKey<Biome> tag) {
        Registry biomeRegistry = this.registryAccess.m_175515_(Registry.f_122885_);
        return biomeRegistry.m_206081_(this.getResourceKey()).m_203656_(tag);
    }
}

