/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.creativetab;

import fuzs.puzzleslib.util.CreativeModeTabBuilder;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public abstract class CreativeModeTabBuilderImpl
implements CreativeModeTabBuilder {
    private static final Item[] POTION_ITEMS = new Item[]{Items.f_42589_, Items.f_42736_, Items.f_42739_, Items.f_42738_};
    final ResourceLocation identifier;
    private Supplier<ItemStack> iconSupplier = () -> ItemStack.f_41583_;
    boolean cacheIcon = true;
    boolean showTitle = true;
    boolean showScrollbar = true;
    boolean alignRight;
    @Nullable
    BiConsumer<NonNullList<ItemStack>, CreativeModeTab> stacksForDisplay;
    boolean appendEnchantments;
    boolean appendPotions;
    boolean showSearch;

    public CreativeModeTabBuilderImpl(String modId, String identifier) {
        this.identifier = new ResourceLocation(modId, identifier);
    }

    ItemStack getIcon() {
        ItemStack stack = this.iconSupplier.get();
        if (stack.m_41619_()) {
            throw new IllegalStateException("Creative tab icon cannot be empty");
        }
        return stack;
    }

    @Override
    public CreativeModeTabBuilder setIcon(Supplier<ItemStack> icon) {
        Objects.requireNonNull(icon, "icon supplier was null");
        this.iconSupplier = icon;
        return this;
    }

    @Override
    public CreativeModeTabBuilder disableIconCache() {
        this.cacheIcon = false;
        return this;
    }

    @Override
    public CreativeModeTabBuilder hideTitle() {
        this.showTitle = false;
        return this;
    }

    @Override
    public CreativeModeTabBuilder hideScroll() {
        this.showScrollbar = false;
        return this;
    }

    @Override
    public CreativeModeTabBuilder alignRight() {
        this.alignRight = true;
        return this;
    }

    @Override
    public CreativeModeTabBuilder appendItemsV2(BiConsumer<NonNullList<ItemStack>, CreativeModeTab> itemStacks) {
        Objects.requireNonNull(itemStacks, "item stacks consumer was null");
        this.stacksForDisplay = itemStacks;
        return this;
    }

    @Override
    public CreativeModeTabBuilder appendAllEnchantments() {
        this.appendEnchantments = true;
        return this;
    }

    @Override
    public CreativeModeTabBuilder appendAllPotions() {
        this.appendPotions = true;
        return this;
    }

    @Override
    public CreativeModeTabBuilder showSearch() {
        this.showSearch = true;
        return this;
    }

    void appendAdditionals(NonNullList<ItemStack> itemStacks) {
        if (this.appendEnchantments) {
            this.appendAllEnchantments(arg_0 -> itemStacks.add(arg_0));
        }
        if (this.appendPotions) {
            this.appendAllPotions(arg_0 -> itemStacks.add(arg_0));
        }
    }

    private void appendAllEnchantments(Consumer<ItemStack> itemStacks) {
        Comparator<Map.Entry> comparator = Comparator.comparing(entry -> ((ResourceKey)entry.getKey()).m_135782_().m_135815_());
        this.getNamespacedEntries(Registry.f_122825_, this.identifier.m_135827_()).sorted(comparator).map(Map.Entry::getValue).forEach(enchantment -> itemStacks.accept(EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(enchantment, enchantment.m_6586_()))));
    }

    private void appendAllPotions(Consumer<ItemStack> itemStacks) {
        Comparator<Potion> comparator = Comparator.comparing(potion -> {
            if (potion.m_43488_().isEmpty()) {
                throw new IllegalArgumentException("Cannot compare potions with empty effects!");
            }
            MobEffect effect = ((MobEffectInstance)potion.m_43488_().get(0)).m_19544_();
            ResourceLocation key = Registry.f_122823_.m_7981_((Object)effect);
            Objects.requireNonNull(key, "Mob effect key for class %s is null".formatted(effect.getClass()));
            return key.m_135815_();
        }).thenComparingInt(potion -> ((MobEffectInstance)potion.m_43488_().get(0)).m_19564_()).thenComparingInt(potion -> ((MobEffectInstance)potion.m_43488_().get(0)).m_19557_());
        Potion[] potions = (Potion[])this.getNamespacedEntries((Registry)Registry.f_122828_, this.identifier.m_135827_()).map(Map.Entry::getValue).filter(potion -> !potion.m_43488_().isEmpty()).sorted(comparator).toArray(Potion[]::new);
        for (Item item : POTION_ITEMS) {
            for (Potion potion2 : potions) {
                itemStacks.accept(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)item), (Potion)potion2));
            }
        }
    }

    private <T> Stream<Map.Entry<ResourceKey<T>, T>> getNamespacedEntries(Registry<T> registry, String namespace) {
        return registry.m_6579_().stream().filter(entry -> ((ResourceKey)entry.getKey()).m_135782_().m_135827_().equals(namespace));
    }
}

