/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.network;

import com.mrcrayfish.furniture.network.message.C2SMessageLockCrate;
import com.mrcrayfish.furniture.network.message.C2SMessageOpenMailBox;
import com.mrcrayfish.furniture.network.message.C2SMessageSendMail;
import com.mrcrayfish.furniture.network.message.C2SMessageSetDoorMat;
import com.mrcrayfish.furniture.network.message.C2SMessageSetMailBoxName;
import com.mrcrayfish.furniture.network.message.IMessage;
import com.mrcrayfish.furniture.network.message.S2CMessageFlipGrill;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public class PacketHandler {
    public static final String PROTOCOL_VERSION = "1";
    private static SimpleChannel instance;
    private static int nextId;

    public static void init() {
        instance = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("cfm", "network")).networkProtocolVersion(() -> PROTOCOL_VERSION).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).simpleChannel();
        PacketHandler.register(C2SMessageLockCrate.class, new C2SMessageLockCrate(), NetworkDirection.PLAY_TO_SERVER);
        PacketHandler.register(C2SMessageSendMail.class, new C2SMessageSendMail(), NetworkDirection.PLAY_TO_SERVER);
        PacketHandler.register(C2SMessageSetMailBoxName.class, new C2SMessageSetMailBoxName(), NetworkDirection.PLAY_TO_SERVER);
        PacketHandler.register(C2SMessageOpenMailBox.class, new C2SMessageOpenMailBox(), NetworkDirection.PLAY_TO_SERVER);
        PacketHandler.register(S2CMessageFlipGrill.class, new S2CMessageFlipGrill(), NetworkDirection.PLAY_TO_CLIENT);
        PacketHandler.register(C2SMessageSetDoorMat.class, new C2SMessageSetDoorMat(), NetworkDirection.PLAY_TO_SERVER);
    }

    private static <T> void register(Class<T> clazz, IMessage<T> message, @Nullable NetworkDirection direction) {
        instance.registerMessage(nextId++, clazz, message::encode, message::decode, message::handle, Optional.ofNullable(direction));
    }

    public static SimpleChannel getPlayChannel() {
        return instance;
    }

    static {
        nextId = 0;
    }
}

