/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.forge.init;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.ModLoadingWarning;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLConfig;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.entity.EntityDataIDSyncHandler;
import org.embeddedt.modernfix.forge.ModernFixConfig;
import org.embeddedt.modernfix.forge.classloading.ModFileScanDataDeduplicator;
import org.embeddedt.modernfix.forge.init.ModernFixClientForge;
import org.embeddedt.modernfix.forge.packet.PacketHandler;
import org.embeddedt.modernfix.forge.registry.ObjectHolderClearer;

@Mod(value="modernfix")
public class ModernFixForge {
    private static ModernFix commonMod;

    public ModernFixForge() {
        commonMod = new ModernFix();
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onLoadComplete);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::registerItems);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> MinecraftForge.EVENT_BUS.register((Object)new ModernFixClientForge()));
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ModernFixConfig.COMMON_CONFIG);
        PacketHandler.register();
        ModFileScanDataDeduplicator.deduplicate();
    }

    @SubscribeEvent
    public void onDatapackSync(OnDatapackSyncEvent event) {
        if (event.getPlayer() != null) {
            if (!ServerLifecycleHooks.getCurrentServer().m_6982_() && event.getPlayerList().m_11309_() == 0) {
                return;
            }
            EntityDataIDSyncHandler.onDatapackSyncEvent(event.getPlayer());
        }
    }

    private void registerItems(RegisterEvent event) {
        if (Boolean.getBoolean("modernfix.largeRegistryTest")) {
            event.register(ForgeRegistries.Keys.ITEMS, helper -> {
                Item.Properties props = new Item.Properties();
                for (int i = 0; i < 1000000; ++i) {
                    helper.register(new ResourceLocation("modernfix", "item_" + i), (Object)new Item(props));
                }
            });
        }
    }

    private static boolean dfuModPresent() {
        if (FMLConfig.isOptimizedDFUDisabled()) {
            return true;
        }
        for (String modId : new String[]{"lazydfu", "datafixerslayer"}) {
            if (!ModList.get().isLoaded(modId)) continue;
            return true;
        }
        return !FMLLoader.isProduction();
    }

    @SubscribeEvent
    public void commonSetup(FMLCommonSetupEvent event) {
        if (!ModernFixForge.dfuModPresent()) {
            event.enqueueWork(() -> ModLoader.get().addWarning(new ModLoadingWarning(ModLoadingContext.get().getActiveContainer().getModInfo(), ModLoadingStage.COMMON_SETUP, "modernfix.no_lazydfu", new Object[0])));
        }
        ObjectHolderClearer.clearThrowables();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onServerDead(ServerStoppedEvent event) {
        commonMod.onServerDead(event.getServer());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLoadComplete(FMLLoadCompleteEvent event) {
        commonMod.onLoadComplete();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onServerStarted(ServerStartedEvent event) {
        commonMod.onServerStarted();
    }
}

