/*
 * Decompiled with CFR 0.152.
 */
package dev.limonblaze.originsclasses.common.event;

import dev.limonblaze.originsclasses.common.OriginsClassesCommon;
import dev.limonblaze.originsclasses.common.apoli.configuration.ModifyValueBiEntityConfiguration;
import dev.limonblaze.originsclasses.common.apoli.power.ActionOnTamePower;
import dev.limonblaze.originsclasses.common.apoli.power.ModifyCraftResultPower;
import dev.limonblaze.originsclasses.common.apoli.power.ModifyCraftedFoodPower;
import dev.limonblaze.originsclasses.common.apoli.power.ModifyValueBiEntityPower;
import dev.limonblaze.originsclasses.common.event.ModifyCraftResultEvent;
import dev.limonblaze.originsclasses.common.network.S2CInfiniteTrader;
import dev.limonblaze.originsclasses.common.registry.OriginsClassesPowers;
import dev.limonblaze.originsclasses.common.tag.OriginsClassesEntityTypeTags;
import dev.limonblaze.originsclasses.core.mixin.accessor.minecraft.LivingEntityAccessor;
import dev.limonblaze.originsclasses.util.ClericHelper;
import dev.limonblaze.originsclasses.util.ClientConfig;
import dev.limonblaze.originsclasses.util.ClientUtils;
import dev.limonblaze.originsclasses.util.CommonUtils;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredBiEntityCondition;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.power.factory.PowerFactory;
import io.github.edwinmindcraft.apoli.common.power.DummyPower;
import io.github.edwinmindcraft.apoli.common.power.ModifyFoodPower;
import io.github.edwinmindcraft.apoli.common.power.ModifyValuePower;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.TippedArrowItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.enchanting.EnchantmentLevelSetEvent;
import net.minecraftforge.event.entity.living.AnimalTameEvent;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber
public class PowerEventHandler {
    public static final String POTION_BONUS_TRANSLATION_KEY = "tooltip.origins_classes.potion_bonus";
    public static final String FOOD_TRANSLATION_KEY = "tooltip.origins_classes.food";
    public static final String SATURATION_MODIFIER_TRANSLATION_KEY = "tooltip.origins_classes.saturation_modifier";

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onAnimalTame(AnimalTameEvent event) {
        ActionOnTamePower.apply((Entity)event.getTamer(), (Entity)event.getAnimal());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onBabyEntitySpawn(BabyEntitySpawnEvent event) {
        Mob mob;
        AgeableMob child = event.getChild();
        if (child != null && (mob = event.getParentA()) instanceof OwnableEntity) {
            OwnableEntity a = (OwnableEntity)mob;
            mob = event.getParentB();
            if (mob instanceof OwnableEntity) {
                OwnableEntity b = (OwnableEntity)mob;
                if (a.m_21826_() != null && Objects.equals(a.m_21805_(), b.m_21805_())) {
                    ActionOnTamePower.apply(a.m_21826_(), (Entity)child);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPotionGained(MobEffectEvent.Added event) {
        LivingEntity source;
        MobEffectInstance effect = event.getEffectInstance();
        LivingEntity owner = event.getEntity();
        Object object = source = event.getEffectSource() == null ? owner : event.getEffectSource();
        if (!effect.m_19571_() && IPowerContainer.hasPower((Entity)owner, (PowerFactory)((DummyPower)OriginsClassesPowers.TAMED_POTION_DIFFUSAL.get()))) {
            owner.f_19853_.m_6443_(LivingEntity.class, owner.m_20191_().m_82363_(8.0, 2.0, 8.0).m_82363_(-8.0, -2.0, -8.0), e -> {
                OwnableEntity ownable;
                return e instanceof OwnableEntity && Objects.equals((ownable = (OwnableEntity)e).m_21805_(), owner.m_20148_());
            }).forEach(arg_0 -> PowerEventHandler.lambda$onPotionGained$1(effect, (Entity)source, arg_0));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEnchantmentLevel(EnchantmentLevelSetEvent event) {
        ItemStack stack = event.getItem();
        if (!stack.m_41782_()) {
            return;
        }
        CompoundTag entry = CommonUtils.getOriginsClassesTag(stack.m_41783_());
        if (!entry.m_128425_("Enchanter", 11)) {
            return;
        }
        Player player = event.getLevel().m_46003_(entry.m_128342_("Enchanter"));
        if (player != null) {
            event.setEnchantLevel(Mth.m_14143_((float)IPowerContainer.modify((Entity)player, (PowerFactory)((ModifyValuePower)OriginsClassesPowers.MODIFY_ENCHANTING_LEVEL.get()), (float)event.getEnchantLevel(), cp -> ((ConfiguredPower)cp.get()).isActive((Entity)player))));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onBoneMeal(BonemealEvent event) {
        Block block;
        int count = CommonUtils.rollInt(IPowerContainer.modify((Entity)event.getEntity(), (PowerFactory)((ModifyValuePower)OriginsClassesPowers.MODIFY_BONE_MEAL.get()), (double)1.0), event.getEntity().m_217043_());
        if (count == 0) {
            event.setCanceled(true);
            event.setResult(Event.Result.DENY);
        } else if (count > 1 && (block = event.getBlock().m_60734_()) instanceof BonemealableBlock) {
            BonemealableBlock fertilizable = (BonemealableBlock)block;
            Level world = event.getLevel();
            BlockPos pos = event.getPos();
            BlockState state = event.getBlock();
            if (world instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)world;
                if (fertilizable.m_7370_((BlockGetter)world, pos, state, false)) {
                    for (int i = 0; i < count - 1; ++i) {
                        if (!fertilizable.m_214167_(world, world.f_46441_, pos, state)) continue;
                        fertilizable.m_214148_(serverWorld, world.f_46441_, pos, state);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onInteractEntity(PlayerInteractEvent.EntityInteract event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            if (event.getTarget().m_6095_().m_204039_(OriginsClassesEntityTypeTags.INFINITE_TRADER) && IPowerContainer.hasPower((Entity)sp, (PowerFactory)((DummyPower)OriginsClassesPowers.INFINITE_TRADE.get()))) {
                OriginsClassesCommon.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CInfiniteTrader(true));
            } else {
                OriginsClassesCommon.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2CInfiniteTrader(false));
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent event) {
        EntityDamageSource eds;
        DamageSource damageSource = event.getSource();
        if (damageSource instanceof EntityDamageSource && (damageSource = (eds = (EntityDamageSource)damageSource).m_7639_()) instanceof Player) {
            Player player = (Player)damageSource;
            LivingEntity target = event.getEntity();
            int amount = CommonUtils.rollInt(IPowerContainer.modify((Entity)player, (PowerFactory)((ModifyValueBiEntityPower)((Object)OriginsClassesPowers.MODIFY_ENTITY_LOOT.get())), (float)1.0f, cp -> ((ConfiguredPower)cp.get()).isActive((Entity)player) && ConfiguredBiEntityCondition.check(((ModifyValueBiEntityConfiguration)((ConfiguredPower)cp.get()).getConfiguration()).condition(), (Entity)player, (Entity)target)), player.m_217043_());
            for (int i = 1; i < amount; ++i) {
                ((LivingEntityAccessor)target).invokeDropFromLootTable(event.getSource(), true);
            }
        }
    }

    @SubscribeEvent
    public static void onItemCrafted(ModifyCraftResultEvent event) {
        Player player = event.getEntity();
        ItemStack stack = event.getCrafted();
        if (stack.getFoodProperties((LivingEntity)player) != null) {
            stack = ModifyCraftedFoodPower.modify(player, stack, event.getType());
        }
        stack = ModifyCraftResultPower.modify(player, stack, event.getType());
        event.setCrafted(stack);
    }

    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent event) {
        Player player = event.getEntity();
        if (player == null) {
            return;
        }
        ItemStack stack = event.getItemStack();
        List tooltip = event.getToolTip();
        if (((Boolean)ClientConfig.CONFIG.showModifyFoodTooltip.get()).booleanValue() && stack.getFoodProperties((LivingEntity)player) != null) {
            ArrayList foodModifiers = new ArrayList();
            ArrayList saturationModifiers = new ArrayList();
            ModifyFoodPower.getValidPowers((Entity)player, (ItemStack)stack).stream().map(ConfiguredPower::getConfiguration).forEach(config -> {
                foodModifiers.addAll(config.foodModifiers().entries());
                saturationModifiers.addAll(config.saturationModifiers().entries());
            });
            foodModifiers.forEach(mod -> tooltip.add(ClientUtils.modifierTooltip(mod, FOOD_TRANSLATION_KEY)));
            saturationModifiers.forEach(mod -> tooltip.add(ClientUtils.modifierTooltip(mod, SATURATION_MODIFIER_TRANSLATION_KEY)));
        }
        if (((Boolean)ClientConfig.CONFIG.showPotionBonusTooltip.get()).booleanValue() && (stack.m_41720_() instanceof PotionItem || stack.m_41720_() instanceof TippedArrowItem) && stack.m_41782_() && ClericHelper.getPotionBonus(stack.m_41783_())) {
            tooltip.add(ClientUtils.translate(POTION_BONUS_TRANSLATION_KEY, new Object[0]).m_130940_(ChatFormatting.BLUE));
        }
    }

    private static /* synthetic */ void lambda$onPotionGained$1(MobEffectInstance effect, Entity source, LivingEntity e) {
        e.m_147207_(effect, source);
    }
}

