/*
 * Decompiled with CFR 0.152.
 */
package com.matyrobbrt.okzoomer.config;

import com.matyrobbrt.okzoomer.config.ConfigEnums;
import com.matyrobbrt.okzoomer.network.OkZoomerNetwork;
import com.matyrobbrt.okzoomer.network.packet.AcknowledgeModPacket;
import com.matyrobbrt.okzoomer.network.packet.DisableZoomPacket;
import com.matyrobbrt.okzoomer.network.packet.DisableZoomScrollingPacket;
import com.matyrobbrt.okzoomer.network.packet.ForceClassicModePacket;
import com.matyrobbrt.okzoomer.network.packet.ForceOverlayPacket;
import com.matyrobbrt.okzoomer.network.packet.ForceSpyglassPacket;
import com.matyrobbrt.okzoomer.network.packet.ForceZoomDivisorPacket;
import com.matyrobbrt.okzoomer.utils.ZoomUtils;
import java.util.ArrayList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;

public class ServerConfig {
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.BooleanValue ALLOW_ZOOM;
    public static final ForgeConfigSpec.BooleanValue DISABLE_ZOOM_SCROLLING;
    public static final ForgeConfigSpec.BooleanValue FORCE_CLASSIC_MODE;
    public static final ForgeConfigSpec.DoubleValue MINIMUM_ZOOM_DIVISOR;
    public static final ForgeConfigSpec.DoubleValue MAXIMUM_ZOOM_DIVISOR;
    public static final ForgeConfigSpec.EnumValue<ConfigEnums.SpyglassDependency> SPYGLASS_DEPENDENCY;
    public static final ForgeConfigSpec.EnumValue<ConfigEnums.ZoomOverlays> ZOOM_OVERLAY;

    @SubscribeEvent
    static void configChanged(ModConfigEvent.Reloading event) {
        if (event.getConfig().getType() != ModConfig.Type.SERVER) {
            return;
        }
        ZoomUtils.LOGGER.info("THe OkZoomer server config has been changed!");
        MinecraftServer currentServer = ServerLifecycleHooks.getCurrentServer();
        if (currentServer != null) {
            currentServer.m_6846_().m_11314_().forEach(ServerConfig::sendPacket);
        }
    }

    public static void sendPacket(ServerPlayer player) {
        if (OkZoomerNetwork.EXISTENCE_CHANNEL.isRemotePresent(player.f_8906_.f_9742_)) {
            ArrayList<Object> packets = new ArrayList<Object>();
            packets.add(new DisableZoomPacket((Boolean)ALLOW_ZOOM.get() == false));
            packets.add(new DisableZoomScrollingPacket((Boolean)DISABLE_ZOOM_SCROLLING.get()));
            packets.add(new ForceClassicModePacket((Boolean)FORCE_CLASSIC_MODE.get()));
            packets.add(new ForceZoomDivisorPacket((Double)MINIMUM_ZOOM_DIVISOR.get(), (Double)MAXIMUM_ZOOM_DIVISOR.get()));
            packets.add(new ForceSpyglassPacket((ConfigEnums.SpyglassDependency)((Object)SPYGLASS_DEPENDENCY.get())));
            packets.add(new ForceOverlayPacket((ConfigEnums.ZoomOverlays)((Object)ZOOM_OVERLAY.get())));
            packets.add(new AcknowledgeModPacket());
            packets.forEach(pkt -> OkZoomerNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), pkt));
        }
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        ALLOW_ZOOM = builder.comment("If players should be allowed to zoom using OkZoomer.").define("allow_zoom", true);
        DISABLE_ZOOM_SCROLLING = builder.comment("If false, allows players to use the scroll key to adjust zoom.").define("disable_zoom_scrolling", false);
        FORCE_CLASSIC_MODE = builder.comment("If true, players will be forced to use classic mode for zooming.").define("force_classic_mode", false);
        MINIMUM_ZOOM_DIVISOR = builder.comment("The minimum value that players can scroll down.").defineInRange("minimum_zoom_divisor", 1.0, 0.0, Double.MAX_VALUE);
        MAXIMUM_ZOOM_DIVISOR = builder.comment("The maximum value that players can scroll down.").defineInRange("maximum_zoom_divisor", 50.0, 0.0, Double.MAX_VALUE);
        SPYGLASS_DEPENDENCY = builder.comment("Enforce a spyglass dependency for zoom.").defineEnum("spyglass_dependency", (Enum)ConfigEnums.SpyglassDependency.OFF);
        ZOOM_OVERLAY = builder.comment("Enforce a zoom overlay over the zoom.").defineEnum("zoom_overlay", (Enum)ConfigEnums.ZoomOverlays.OFF);
        SPEC = builder.build();
    }
}

