/*
 * Decompiled with CFR 0.152.
 */
package com.matyrobbrt.okzoomer.zoom;

import com.matyrobbrt.okzoomer.api.TransitionMode;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class LinearTransitionMode
implements TransitionMode {
    private static final ResourceLocation TRANSITION_ID = new ResourceLocation("okzoomer", "linear_transition");
    private boolean active = false;
    private double minimumLinearStep;
    private double maximumLinearStep;
    private double linearStep;
    private double fovMultiplier;
    private float internalMultiplier;
    private float lastInternalMultiplier;

    public LinearTransitionMode(double minimumLinearStep, double maximumLinearStep) {
        this.minimumLinearStep = minimumLinearStep;
        this.maximumLinearStep = maximumLinearStep;
        this.internalMultiplier = 1.0f;
        this.lastInternalMultiplier = 1.0f;
    }

    @Override
    public ResourceLocation getId() {
        return TRANSITION_ID;
    }

    @Override
    public boolean getActive() {
        return this.active;
    }

    @Override
    public double applyZoom(double fov, float tickDelta) {
        this.fovMultiplier = Mth.m_14179_((float)tickDelta, (float)this.lastInternalMultiplier, (float)this.internalMultiplier);
        return fov * this.fovMultiplier;
    }

    @Override
    public void tick(boolean active, double divisor) {
        double zoomMultiplier = 1.0 / divisor;
        this.lastInternalMultiplier = this.internalMultiplier;
        this.linearStep = Mth.m_14008_((double)zoomMultiplier, (double)this.minimumLinearStep, (double)this.maximumLinearStep);
        this.internalMultiplier = Mth.m_14121_((float)this.internalMultiplier, (float)((float)zoomMultiplier), (float)((float)this.linearStep));
        if (!active && this.fovMultiplier == (double)this.internalMultiplier || active) {
            this.active = active;
        }
    }

    @Override
    public double getInternalMultiplier() {
        return this.internalMultiplier;
    }
}

