/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.ponder;

import com.mojang.authlib.GameProfile;
import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.registry.CREntities;
import com.railwayteam.railways.registry.CRItems;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.foundation.ponder.ElementLink;
import com.simibubi.create.foundation.ponder.PonderPalette;
import com.simibubi.create.foundation.ponder.SceneBuilder;
import com.simibubi.create.foundation.ponder.SceneBuildingUtil;
import com.simibubi.create.foundation.ponder.element.EntityElement;
import com.simibubi.create.foundation.ponder.element.InputWindowElement;
import com.simibubi.create.foundation.utility.Pointing;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Rotations;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.piston.PistonHeadBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class ConductorScenes {
    public static ElementLink<EntityElement> makePlayerStand(SceneBuilder scene, String playerName, int leatherColor, Vec3 pos) {
        ItemStack playerHead = new ItemStack((ItemLike)Items.f_42680_);
        GameProfile gameprofile = new GameProfile(null, playerName);
        SkullBlockEntity.m_155738_((GameProfile)gameprofile, p_151177_ -> {
            CompoundTag itemTag = playerHead.m_41784_();
            itemTag.m_128365_("SkullOwner", (Tag)NbtUtils.m_129230_((CompoundTag)new CompoundTag(), (GameProfile)p_151177_));
            playerHead.m_41751_(itemTag);
        });
        ElementLink player = scene.world.createEntity(w -> {
            ArmorStand entity = (ArmorStand)EntityType.f_20529_.m_20615_(w);
            entity.m_6034_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
            entity.f_19854_ = pos.f_82479_;
            entity.f_19855_ = pos.f_82480_;
            entity.f_19856_ = pos.f_82481_;
            entity.f_20925_ = 0.0f;
            entity.f_19859_ = 210.0f;
            entity.m_146922_(210.0f);
            entity.f_20886_ = 210.0f;
            entity.f_20885_ = 210.0f;
            entity.m_6842_(true);
            return entity;
        });
        scene.world.modifyEntity(player, entity -> {
            entity.m_8061_(EquipmentSlot.HEAD, playerHead);
            CompoundTag leatherTag = new CompoundTag();
            CompoundTag displayTag = new CompoundTag();
            displayTag.m_128405_("color", leatherColor);
            leatherTag.m_128365_("display", (Tag)displayTag);
            ItemStack chestplate = new ItemStack((ItemLike)Items.f_42408_);
            ItemStack leggings = new ItemStack((ItemLike)Items.f_42462_);
            ItemStack boots = new ItemStack((ItemLike)Items.f_42463_);
            chestplate.m_41751_(leatherTag);
            leggings.m_41751_(leatherTag);
            boots.m_41751_(leatherTag);
            entity.m_8061_(EquipmentSlot.CHEST, chestplate);
            entity.m_8061_(EquipmentSlot.LEGS, leggings);
            entity.m_8061_(EquipmentSlot.FEET, boots);
        });
        return player;
    }

    public static ElementLink<EntityElement> makeConductor(SceneBuilder scene, DyeColor color, Vec3 pos) {
        return scene.world.createEntity(w -> {
            ConductorEntity entity = (ConductorEntity)CREntities.CONDUCTOR.create(w);
            entity.setColor(color);
            entity.m_8061_(EquipmentSlot.HEAD, CRItems.ITEM_CONDUCTOR_CAP.get(color).asStack());
            entity.m_6034_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
            entity.f_19854_ = pos.f_82479_;
            entity.f_19855_ = pos.f_82480_;
            entity.f_19856_ = pos.f_82481_;
            entity.f_20925_ = 0.0f;
            entity.f_19859_ = 210.0f;
            entity.m_146922_(210.0f);
            entity.f_20886_ = 210.0f;
            entity.f_20885_ = 210.0f;
            return entity;
        });
    }

    public static void constructing(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("conductor_constructing", "Constructing a Conductor");
        scene.configureBasePlate(0, 0, 3);
        scene.scaleSceneView(1.0f);
        scene.showBasePlate();
        scene.rotateCameraY(85.0f);
        scene.idle(10);
        BlockPos casing = util.grid.at(1, 1, 1);
        BlockPos deployer = util.grid.at(1, 3, 1);
        BlockPos cog = util.grid.at(1, 3, 2);
        scene.world.showSection(util.select.position(casing), Direction.DOWN);
        scene.overlay.showText(60).pointAt(util.vector.topOf(casing)).attachKeyFrame().placeNearTarget().text("Conductors are constructed with an andesite casing.");
        scene.idle(20);
        scene.overlay.showControls(new InputWindowElement(util.vector.blockSurface(casing, Direction.UP), Pointing.DOWN).rightClick().withItem(CRItems.ITEM_CONDUCTOR_CAP.get(DyeColor.RED).asStack()), 40);
        scene.idle(50);
        scene.world.showSection(util.select.position(deployer), Direction.DOWN);
        scene.world.showSection(util.select.position(cog), Direction.NORTH);
        scene.world.setKineticSpeed(util.select.position(cog), 16.0f);
        scene.idle(5);
        scene.world.moveDeployer(deployer, 1.0f, 25);
        scene.idle(26);
        scene.world.destroyBlock(casing);
        ElementLink<EntityElement> conductor = ConductorScenes.makeConductor(scene, DyeColor.RED, Vec3.m_82539_((Vec3i)casing));
        scene.world.moveDeployer(deployer, -1.0f, 25);
        scene.idle(30);
        scene.world.hideSection(util.select.position(cog), Direction.SOUTH);
        scene.world.hideSection(util.select.position(deployer), Direction.UP);
    }

    public static void redstoning(SceneBuilder scene, SceneBuildingUtil util) {
        int finalI;
        int finalI2;
        int finalI3;
        scene.title("conductor_redstoning", "Remote Redstone with Conductors");
        scene.configureBasePlate(0, 0, 6);
        scene.scaleSceneView(1.0f);
        scene.showBasePlate();
        scene.rotateCameraY(85.0f);
        scene.idle(10);
        BlockPos button = util.grid.at(3, 1, 0);
        BlockPos corner = util.grid.at(5, 1, 0);
        BlockPos lamp = util.grid.at(5, 1, 5);
        BlockPos buttonConductorPos = util.grid.at(4, 1, 1);
        ElementLink<EntityElement> buttonConductor = ConductorScenes.makeConductor(scene, DyeColor.RED, Vec3.m_82539_((Vec3i)buttonConductorPos));
        scene.world.modifyEntity(buttonConductor, entity -> entity.m_7618_(EntityAnchorArgument.Anchor.EYES, Vec3.m_82512_((Vec3i)button)));
        for (int x = 3; x <= 5; ++x) {
            scene.world.showSection(util.select.position(util.grid.at(x, 1, 0)), Direction.DOWN);
            scene.idle(2);
        }
        for (int z = 1; z <= 5; ++z) {
            scene.world.showSection(util.select.position(util.grid.at(5, 1, z)), Direction.DOWN);
            scene.idle(2);
        }
        scene.overlay.showText(50).pointAt(util.vector.topOf(buttonConductorPos)).attachKeyFrame().placeNearTarget().text("Conductors can press buttons when a player looks at them.");
        scene.idle(20);
        ElementLink<EntityElement> player = ConductorScenes.makePlayerStand(scene, "Slimeist", 65280, Vec3.m_82539_((Vec3i)util.grid.at(2, 1, 2)));
        scene.world.modifyEntity(player, entity -> entity.m_7618_(EntityAnchorArgument.Anchor.EYES, Vec3.m_82512_((Vec3i)buttonConductorPos.m_6625_(2))));
        scene.idle(15);
        int i = 0;
        while (i <= 20) {
            finalI3 = i++;
            scene.world.modifyEntity(player, entity -> {
                ArmorStand stand = (ArmorStand)entity;
                stand.m_31597_(new Rotations((float)finalI3, 0.0f, 0.0f));
            });
            scene.idle(1);
        }
        scene.idle(20);
        scene.overlay.showBigLine(PonderPalette.RED, util.vector.centerOf(util.grid.at(2, 2, 2)), util.vector.topOf(buttonConductorPos), 40);
        scene.world.toggleRedstonePower(util.select.fromTo(button, corner));
        scene.world.toggleRedstonePower(util.select.fromTo(corner.m_122019_(), lamp));
        scene.effects.indicateRedstone(button);
        scene.idle(30);
        for (i = 20; i > 0; --i) {
            finalI3 = i;
            scene.world.modifyEntity(player, entity -> {
                ArmorStand stand = (ArmorStand)entity;
                stand.m_31597_(new Rotations((float)finalI3, 0.0f, 0.0f));
            });
            scene.idle(1);
            if (i == 10) {
                scene.world.toggleRedstonePower(util.select.fromTo(button, corner));
                scene.world.toggleRedstonePower(util.select.fromTo(corner.m_122019_(), lamp.m_122012_()));
            }
            if (i != 6) continue;
            scene.world.toggleRedstonePower(util.select.position(lamp));
        }
        scene.rotateCameraY(-85.0f);
        scene.idle(30);
        BlockPos piston = util.grid.at(0, 1, 5);
        BlockPos lever = util.grid.at(1, 1, 5);
        scene.world.showSection(util.select.position(piston), Direction.DOWN);
        scene.idle(30);
        scene.world.showSection(util.select.position(lever), Direction.WEST);
        BlockPos leverConductorPos = util.grid.at(3, 1, 5);
        scene.idle(10);
        ElementLink<EntityElement> leverConductor = ConductorScenes.makeConductor(scene, DyeColor.BLUE, Vec3.m_82539_((Vec3i)leverConductorPos));
        scene.world.modifyEntity(leverConductor, entity -> entity.m_7618_(EntityAnchorArgument.Anchor.EYES, Vec3.m_82512_((Vec3i)lever)));
        scene.overlay.showText(30).pointAt(util.vector.topOf(leverConductorPos)).attachKeyFrame().placeNearTarget().text("Conductors also toggle levers when a player looks at them.");
        scene.idle(35);
        scene.world.modifyEntity(player, entity -> {
            entity.m_7618_(EntityAnchorArgument.Anchor.EYES, Vec3.m_82512_((Vec3i)leverConductorPos));
            ArmorStand stand = (ArmorStand)entity;
            stand.m_31597_(new Rotations(entity.m_146909_(), 0.0f, 0.0f));
        });
        scene.idle(2);
        scene.overlay.showBigLine(PonderPalette.BLUE, util.vector.centerOf(util.grid.at(2, 2, 2)), util.vector.topOf(leverConductorPos), 40);
        scene.world.toggleRedstonePower(util.select.position(lever));
        scene.effects.indicateRedstone(lever);
        scene.world.modifyBlock(piston, state -> (BlockState)state.m_61124_((Property)PistonBaseBlock.f_60153_, (Comparable)Boolean.valueOf(true)), false);
        scene.world.showSection(util.select.position(util.grid.at(0, 2, 5)), Direction.UP);
        scene.world.setBlock(piston.m_7494_(), (BlockState)Blocks.f_50040_.m_49966_().m_61124_((Property)PistonHeadBlock.f_52588_, (Comparable)Direction.UP), false);
        scene.idle(30);
        int i2 = 0;
        while (i2 <= 10) {
            finalI2 = i2++;
            scene.world.modifyEntity(player, entity -> {
                ArmorStand stand = (ArmorStand)entity;
                stand.m_31597_(new Rotations(entity.m_146909_(), (float)finalI2 * 3.5f, 0.0f));
            });
            scene.idle(1);
        }
        scene.idle(10);
        scene.world.modifyEntity(player, entity -> entity.m_8061_(EquipmentSlot.HEAD, CRItems.ITEM_CONDUCTOR_CAP.get(DyeColor.RED).asStack()));
        scene.overlay.showText(30).pointAt(util.vector.topOf(util.grid.at(2, 1, 2))).attachKeyFrame().placeNearTarget().text("Conductors do not activate redstone if a player is wearing a different-colored cap from them.");
        scene.idle(25);
        i2 = 10;
        while (i2 > 0) {
            finalI2 = i2--;
            scene.world.modifyEntity(player, entity -> {
                ArmorStand stand = (ArmorStand)entity;
                stand.m_31597_(new Rotations(entity.m_146909_(), (float)finalI2 * 3.5f, 0.0f));
            });
            scene.idle(1);
        }
        Vec3 playerPoint = util.vector.centerOf(util.grid.at(2, 2, 2));
        Vec3 conductorPoint = util.vector.topOf(leverConductorPos);
        Vec3 middlePoint = playerPoint.m_82549_(conductorPoint).m_82490_(0.5);
        scene.overlay.showLine(PonderPalette.RED, playerPoint, middlePoint, 40);
        scene.overlay.showLine(PonderPalette.BLUE, conductorPoint, middlePoint, 40);
        scene.idle(45);
        scene.world.modifyEntity(player, entity -> {
            entity.m_7618_(EntityAnchorArgument.Anchor.EYES, Vec3.m_82512_((Vec3i)buttonConductorPos.m_6625_(2)));
            ((ArmorStand)entity).m_31597_(new Rotations(0.0f, 0.0f, 0.0f));
        });
        scene.idle(15);
        int i3 = 0;
        while (i3 <= 20) {
            finalI = i3++;
            scene.world.modifyEntity(player, entity -> {
                ArmorStand stand = (ArmorStand)entity;
                stand.m_31597_(new Rotations((float)finalI, 0.0f, 0.0f));
            });
            scene.idle(1);
        }
        scene.idle(20);
        scene.overlay.showBigLine(PonderPalette.RED, util.vector.centerOf(util.grid.at(2, 2, 2)), util.vector.topOf(buttonConductorPos), 40);
        scene.world.toggleRedstonePower(util.select.fromTo(button, corner));
        scene.world.toggleRedstonePower(util.select.fromTo(corner.m_122019_(), lamp));
        scene.effects.indicateRedstone(button);
        scene.idle(30);
        for (i3 = 20; i3 > 0; --i3) {
            finalI = i3;
            scene.world.modifyEntity(player, entity -> {
                ArmorStand stand = (ArmorStand)entity;
                stand.m_31597_(new Rotations((float)finalI, 0.0f, 0.0f));
            });
            scene.idle(1);
            if (i3 == 10) {
                scene.world.toggleRedstonePower(util.select.fromTo(button, corner));
                scene.world.toggleRedstonePower(util.select.fromTo(corner.m_122019_(), lamp.m_122012_()));
            }
            if (i3 != 6) continue;
            scene.world.toggleRedstonePower(util.select.position(lamp));
        }
    }

    public static void toolboxing(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("conductor_toolboxing", "Toolbox Transport with Conductors");
        scene.configureBasePlate(0, 0, 3);
        scene.scaleSceneView(1.0f);
        scene.showBasePlate();
        scene.rotateCameraY(85.0f);
        scene.idle(10);
        BlockPos conductorPos = util.grid.at(1, 1, 1);
        ElementLink<EntityElement> buttonConductor = ConductorScenes.makeConductor(scene, DyeColor.RED, Vec3.m_82539_((Vec3i)conductorPos));
        scene.overlay.showText(40).pointAt(util.vector.topOf(conductorPos)).attachKeyFrame().placeNearTarget().text("Toolboxes function normally when equipped on Conductors.");
        scene.idle(45);
        ItemStack toolboxStack = AllBlocks.TOOLBOXES.get(DyeColor.LIME).asStack();
        scene.overlay.showControls(new InputWindowElement(util.vector.topOf(conductorPos), Pointing.DOWN).rightClick().withItem(toolboxStack), 40);
        scene.idle(35);
        scene.world.modifyEntity(buttonConductor, entity -> ((ConductorEntity)((Object)entity)).equipToolbox(toolboxStack));
        int i = 0;
        while (i <= 72) {
            int finalI = i++;
            scene.world.modifyEntity(buttonConductor, entity -> {
                entity.m_146922_((float)finalI * 5.0f + 210.0f);
                entity.m_5618_((float)finalI * 5.0f + 210.0f);
                entity.m_5616_((float)finalI * 5.0f + 210.0f);
                entity.m_146867_();
            });
            scene.idle(1);
        }
        scene.overlay.showControls(new InputWindowElement(util.vector.topOf(conductorPos), Pointing.DOWN).rightClick().whileSneaking(), 20);
        scene.idle(15);
        scene.world.modifyEntity(buttonConductor, entity -> ((ConductorEntity)((Object)entity)).unequipToolbox());
        scene.world.createItemEntity(util.vector.of(1.0, 1.0, 1.0), Vec3.f_82478_, toolboxStack);
    }
}

