/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.origins.common;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.CommandDispatcher;
import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.mixin.EntityAccessor;
import io.github.apace100.origins.Origins;
import io.github.apace100.origins.badge.BadgeManager;
import io.github.apace100.origins.command.OriginCommand;
import io.github.apace100.origins.origin.OriginLayers;
import io.github.apace100.origins.origin.OriginRegistry;
import io.github.apace100.origins.power.OriginsPowerTypes;
import io.github.apace100.origins.registry.ModDamageSources;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.power.factory.PowerFactory;
import io.github.edwinmindcraft.apoli.common.power.DummyPower;
import io.github.edwinmindcraft.calio.api.event.CalioDynamicRegistryEvent;
import io.github.edwinmindcraft.calio.api.event.DynamicRegistrationEvent;
import io.github.edwinmindcraft.origins.api.OriginsAPI;
import io.github.edwinmindcraft.origins.api.capabilities.IOriginContainer;
import io.github.edwinmindcraft.origins.api.origin.Origin;
import io.github.edwinmindcraft.origins.api.origin.OriginLayer;
import io.github.edwinmindcraft.origins.api.registry.OriginsDynamicRegistries;
import io.github.edwinmindcraft.origins.common.OriginsCommon;
import io.github.edwinmindcraft.origins.common.OriginsConfigs;
import io.github.edwinmindcraft.origins.common.capabilities.OriginContainer;
import io.github.edwinmindcraft.origins.common.network.S2COpenOriginScreen;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.Advancement;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="origins")
public class OriginsEventHandler {
    private static final Method DECREASE_AIR_SUPPLY = ObfuscationReflectionHelper.findMethod(LivingEntity.class, (String)"m_7302_", (Class[])new Class[]{Integer.TYPE});
    private static final Method INCREASE_AIR_SUPPLY = ObfuscationReflectionHelper.findMethod(LivingEntity.class, (String)"m_7305_", (Class[])new Class[]{Integer.TYPE});

    private static int increaseAirSupply(LivingEntity living, int value) {
        try {
            return (Integer)INCREASE_AIR_SUPPLY.invoke((Object)living, value);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static int decreaseAirSupply(LivingEntity living, int value) {
        try {
            return (Integer)DECREASE_AIR_SUPPLY.invoke((Object)living, value);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        OriginCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof Player) {
            Player player = (Player)object;
            event.addCapability(OriginContainer.ID, (ICapabilityProvider)new OriginContainer(player));
        }
    }

    @SubscribeEvent
    public static void onDataSync(OnDatapackSyncEvent event) {
        PacketDistributor.PacketTarget target = event.getPlayer() == null ? PacketDistributor.ALL.noArg() : PacketDistributor.PLAYER.with(() -> ((OnDatapackSyncEvent)event).getPlayer());
        OriginsCommon.CHANNEL.send(target, (Object)BadgeManager.createPacket());
        if (event.getPlayer() != null) {
            IOriginContainer.get((Entity)event.getPlayer()).map(IOriginContainer::getSynchronizationPacket).ifPresent(packet -> OriginsCommon.CHANNEL.send(target, packet));
        }
    }

    @SubscribeEvent
    public static void onAdvancement(AdvancementEvent event) {
        Advancement advancement = event.getAdvancement();
        Registry<Origin> originsRegistry = OriginsAPI.getOriginsRegistry();
        IOriginContainer.get((Entity)event.getEntity()).ifPresent(container -> container.getOrigins().forEach((layer, origin) -> originsRegistry.m_203636_(origin).stream().flatMap(x -> ((Origin)x.get()).getUpgrades().stream()).filter(x -> Objects.equals(x.advancement(), advancement.m_138327_())).findFirst().ifPresent(upgrade -> {
            try {
                Holder<Origin> target = upgrade.origin();
                if (target.m_203633_() && target.m_203543_().isPresent()) {
                    container.setOrigin((ResourceKey<OriginLayer>)layer, (ResourceKey<Origin>)((ResourceKey)target.m_203543_().get()));
                    container.synchronize();
                    if (!upgrade.announcement().isBlank()) {
                        event.getEntity().m_5661_((Component)Component.m_237115_((String)upgrade.announcement()).m_130940_(ChatFormatting.GOLD), false);
                    }
                }
            }
            catch (IllegalArgumentException e) {
                Origins.LOGGER.error("Could not perform Origins upgrade from {} to {}, as the upgrade origin did not exist!", (Object)origin.m_135782_(), upgrade.origin().m_203543_().orElse(null));
            }
        })));
    }

    @SubscribeEvent
    public static void reloadComplete(CalioDynamicRegistryEvent.LoadComplete event) {
        OriginRegistry.clear();
        OriginLayers.clear();
        MinecraftServer currentServer = ServerLifecycleHooks.getCurrentServer();
        if (currentServer != null) {
            for (ServerPlayer player : currentServer.m_6846_().m_11314_()) {
                IOriginContainer.get((Entity)player).ifPresent(container -> container.onReload(event.getRegistryManager()));
            }
        }
        if (OriginsConfigs.COMMON.updateOriginList(event.getRegistryManager(), (Iterable<Origin>)event.getRegistryManager().get(OriginsDynamicRegistries.ORIGINS_REGISTRY)) && OriginsConfigs.COMMON_SPECS.isLoaded()) {
            OriginsConfigs.COMMON_SPECS.save();
        }
    }

    @SubscribeEvent
    public static void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            if (!event.getEntity().f_19853_.m_5776_()) {
                Objects.requireNonNull(sp.m_20194_()).m_18689_(() -> IOriginContainer.get((Entity)sp).ifPresent(container -> {
                    if (!container.hasAllOrigins()) {
                        container.checkAutoChoosingLayers(true);
                        OriginsCommon.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> sp), (Object)container.getSynchronizationPacket());
                        container.synchronize();
                        if (container.hasAllOrigins()) {
                            container.onChosen(false);
                        } else {
                            OriginsCommon.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new S2COpenOriginScreen(true));
                        }
                    }
                }));
            }
        }
    }

    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking event) {
        Entity entity = event.getTarget();
        if (entity instanceof Player) {
            Player target = (Player)entity;
            entity = event.getEntity();
            if (entity instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)entity;
                if (!event.getEntity().f_19853_.m_5776_()) {
                    Objects.requireNonNull(sp.m_20194_()).m_18689_(() -> IOriginContainer.get((Entity)target).ifPresent(x -> OriginsCommon.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sp), (Object)x.getSynchronizationPacket())));
                }
            }
        }
    }

    @SubscribeEvent
    public static void playerClone(PlayerEvent.Clone event) {
        event.getOriginal().reviveCaps();
        LazyOptional<IOriginContainer> original = IOriginContainer.get((Entity)event.getOriginal());
        LazyOptional<IOriginContainer> player = IOriginContainer.get((Entity)event.getEntity());
        if (original.isPresent() != player.isPresent()) {
            Apoli.LOGGER.info("Capability mismatch: original:{}, new:{}", (Object)original.isPresent(), (Object)player.isPresent());
        }
        player.ifPresent(p -> original.ifPresent(o -> p.deserializeNBT(o.serializeNBT())));
        event.getOriginal().invalidateCaps();
    }

    @SubscribeEvent
    public static void onPlayerTickEnd(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Player player = event.player;
            IOriginContainer.get((Entity)event.player).ifPresent(IOriginContainer::tick);
            if (IPowerContainer.hasPower((Entity)player, (PowerFactory)((DummyPower)OriginsPowerTypes.WATER_BREATHING.get()))) {
                if (!(player.isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get()) || player.m_21023_(MobEffects.f_19608_) || player.m_21023_(MobEffects.f_19592_))) {
                    if (!((EntityAccessor)player).callIsBeingRainedOn()) {
                        int landGain = OriginsEventHandler.increaseAirSupply((LivingEntity)player, 0);
                        player.m_20301_(OriginsEventHandler.decreaseAirSupply((LivingEntity)player, player.m_20146_()) - landGain);
                        if (player.m_20146_() == -20) {
                            player.m_20301_(0);
                            for (int i = 0; i < 8; ++i) {
                                double f = player.m_217043_().m_188500_() - player.m_217043_().m_188500_();
                                double g = player.m_217043_().m_188500_() - player.m_217043_().m_188500_();
                                double h = player.m_217043_().m_188500_() - player.m_217043_().m_188500_();
                                player.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, player.m_20208_(0.5), player.m_20188_() + player.m_217043_().m_188583_() * 0.08, player.m_20262_(0.5), f * 0.5, g * 0.5 + 0.25, h * 0.5);
                            }
                            player.m_6469_(ModDamageSources.NO_WATER_FOR_GILLS, 2.0f);
                        }
                    } else {
                        int landGain = OriginsEventHandler.increaseAirSupply((LivingEntity)player, 0);
                        player.m_20301_(player.m_20146_() - landGain);
                    }
                } else if (player.m_20146_() < player.m_6062_()) {
                    player.m_20301_(OriginsEventHandler.increaseAirSupply((LivingEntity)player, player.m_20146_()));
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onOriginLoad(DynamicRegistrationEvent<Origin> event) {
        if (((Origin)event.getOriginal()).isSpecial()) {
            return;
        }
        if (!OriginsConfigs.COMMON.isOriginEnabled(event.getRegistryName())) {
            event.withCancellationReason("Disabled by config").setCanceled(true);
        } else {
            Origin original = (Origin)event.getOriginal();
            Set originalPowers = original.getPowers().stream().flatMap(HolderSet::m_203614_).collect(Collectors.toUnmodifiableSet());
            HashSet powers = new HashSet(originalPowers);
            powers.removeIf(x -> {
                Optional key = x.m_203543_();
                return key.isEmpty() || !OriginsConfigs.COMMON.isPowerEnabled(event.getRegistryName(), ((ResourceKey)key.get()).m_135782_());
            });
            if (powers.size() != originalPowers.size()) {
                Origins.LOGGER.info("Powers [{}] were disabled by config for origin: {}", (Object)originalPowers.stream().filter(x -> !powers.contains(x)).map(x -> ((ResourceKey)x.m_203543_().orElseThrow()).m_135782_().toString()).collect(Collectors.joining(",")), (Object)event.getRegistryName());
                event.setNewEntry((Object)new Origin((Collection<HolderSet<ConfiguredPower<?, ?>>>)ImmutableList.of((Object)HolderSet.m_205800_((List)ImmutableList.copyOf(powers))), original.getIcon(), original.isUnchoosable(), original.getOrder(), original.getImpact(), original.getName(), original.getDescription(), original.getUpgrades(), original.isSpecial()));
            }
        }
    }
}

