/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.GlStateManager;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.HashMap;
import net.coderbot.iris.pipeline.ClearPass;
import net.coderbot.iris.rendertarget.RenderTargets;
import net.coderbot.iris.shaderpack.PackRenderTargetDirectives;
import net.coderbot.iris.shaderpack.PackShadowDirectives;
import net.coderbot.iris.shadows.ShadowRenderTargets;
import net.coderbot.iris.vendored.joml.Vector4f;

public class ClearPassCreator {
    public static ImmutableList<ClearPass> createClearPasses(RenderTargets renderTargets, boolean fullClear, PackRenderTargetDirectives renderTargetDirectives) {
        int maxDrawBuffers = GlStateManager.m_84092_((int)34852);
        HashMap<Vector4f, IntList> clearByColor = new HashMap<Vector4f, IntList>();
        renderTargetDirectives.getRenderTargetSettings().forEach((bufferI, settings) -> {
            int buffer = bufferI;
            if (fullClear || settings.shouldClear()) {
                Vector4f defaultClearColor = buffer == 0 ? null : (buffer == 1 ? new Vector4f(1.0f, 1.0f, 1.0f, 1.0f) : new Vector4f(0.0f, 0.0f, 0.0f, 0.0f));
                Vector4f clearColor = settings.getClearColor().orElse(defaultClearColor);
                clearByColor.computeIfAbsent(clearColor, color -> new IntArrayList()).add(buffer);
            }
        });
        ArrayList clearPasses = new ArrayList();
        clearByColor.forEach((clearColor, buffers) -> {
            int startIndex = 0;
            while (startIndex < buffers.size()) {
                int[] clearBuffers = new int[Math.min(buffers.size() - startIndex, maxDrawBuffers)];
                for (int i = 0; i < clearBuffers.length; ++i) {
                    clearBuffers[i] = buffers.getInt(startIndex);
                    ++startIndex;
                }
                clearPasses.add(new ClearPass((Vector4f)clearColor, renderTargets::getCurrentWidth, renderTargets::getCurrentHeight, renderTargets.createFramebufferWritingToAlt(clearBuffers), 16384));
                clearPasses.add(new ClearPass((Vector4f)clearColor, renderTargets::getCurrentWidth, renderTargets::getCurrentHeight, renderTargets.createFramebufferWritingToMain(clearBuffers), 16384));
            }
        });
        return ImmutableList.copyOf(clearPasses);
    }

    public static ImmutableList<ClearPass> createShadowClearPasses(ShadowRenderTargets renderTargets, boolean fullClear, PackShadowDirectives renderTargetDirectives) {
        ArrayList<ClearPass> clearPasses = new ArrayList<ClearPass>();
        for (int i = 0; i < renderTargets.getNumColorTextures(); ++i) {
            if (i >= renderTargetDirectives.getColorSamplingSettings().size()) continue;
            if (fullClear || ((PackShadowDirectives.SamplingSettings)renderTargetDirectives.getColorSamplingSettings().get(i)).getClear()) {
                PackShadowDirectives.SamplingSettings samplingSettings = (PackShadowDirectives.SamplingSettings)renderTargetDirectives.getColorSamplingSettings().get(i);
                clearPasses.add(new ClearPass(samplingSettings.getClearColor(), renderTargets::getResolution, renderTargets::getResolution, renderTargets.getFramebufferForColorTexture(i), 16640));
                continue;
            }
            clearPasses.add(new ClearPass(new Vector4f(1.0f), renderTargets::getResolution, renderTargets::getResolution, renderTargets.getFramebufferForColorTexture(i), 256));
        }
        return ImmutableList.copyOf(clearPasses);
    }
}

