/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.samplers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.coderbot.iris.gbuffer_overrides.matching.InputAvailability;
import net.coderbot.iris.gl.sampler.SamplerHolder;
import net.coderbot.iris.rendertarget.RenderTarget;
import net.coderbot.iris.rendertarget.RenderTargets;
import net.coderbot.iris.shaderpack.PackRenderTargetDirectives;
import net.coderbot.iris.shadows.ShadowRenderTargets;
import net.minecraft.client.renderer.texture.AbstractTexture;

public class IrisSamplers {
    public static final int ALBEDO_TEXTURE_UNIT = 0;
    public static final int OVERLAY_TEXTURE_UNIT = 1;
    public static final int LIGHTMAP_TEXTURE_UNIT = 2;
    public static final ImmutableSet<Integer> WORLD_RESERVED_TEXTURE_UNITS = ImmutableSet.of((Object)0, (Object)1, (Object)2);
    public static final ImmutableSet<Integer> COMPOSITE_RESERVED_TEXTURE_UNITS = ImmutableSet.of((Object)1, (Object)2);

    private IrisSamplers() {
    }

    public static void addRenderTargetSamplers(SamplerHolder samplers, Supplier<ImmutableSet<Integer>> flipped, RenderTargets renderTargets, boolean isFullscreenPass) {
        int startIndex;
        for (int i = startIndex = isFullscreenPass ? 0 : 4; i < renderTargets.getRenderTargetCount(); ++i) {
            int index = i;
            IntSupplier sampler = () -> {
                ImmutableSet flippedBuffers = (ImmutableSet)flipped.get();
                RenderTarget target = renderTargets.get(index);
                if (flippedBuffers.contains((Object)index)) {
                    return target.getAltTexture();
                }
                return target.getMainTexture();
            };
            String name = "colortex" + i;
            if (i < PackRenderTargetDirectives.LEGACY_RENDER_TARGETS.size()) {
                String legacyName = (String)PackRenderTargetDirectives.LEGACY_RENDER_TARGETS.get(i);
                if (i == 0 && isFullscreenPass) {
                    samplers.addDefaultSampler(sampler, name, legacyName);
                    continue;
                }
                samplers.addDynamicSampler(sampler, name, legacyName);
                continue;
            }
            samplers.addDynamicSampler(sampler, name);
        }
    }

    public static void addNoiseSampler(SamplerHolder samplers, IntSupplier sampler) {
        samplers.addDynamicSampler(sampler, "noisetex");
    }

    public static boolean hasShadowSamplers(SamplerHolder samplers) {
        ImmutableList shadowSamplers = ImmutableList.of((Object)"shadowtex0", (Object)"shadowtex0HW", (Object)"shadowtex1", (Object)"shadowtex1HW", (Object)"shadow", (Object)"watershadow", (Object)"shadowcolor", (Object)"shadowcolor0", (Object)"shadowcolor1", (Object)"shadowcolorimg0", (Object)"shadowcolorimg1");
        for (String samplerName : shadowSamplers) {
            if (!samplers.hasSampler(samplerName)) continue;
            return true;
        }
        return false;
    }

    public static boolean addShadowSamplers(SamplerHolder samplers, ShadowRenderTargets shadowRenderTargets) {
        boolean usesShadows;
        boolean waterShadowEnabled = samplers.hasSampler("watershadow");
        if (waterShadowEnabled) {
            usesShadows = true;
            samplers.addDynamicSampler(shadowRenderTargets.getDepthTexture()::getTextureId, "shadowtex0", "watershadow");
            samplers.addDynamicSampler(shadowRenderTargets.getDepthTextureNoTranslucents()::getTextureId, "shadowtex1", "shadow");
        } else {
            usesShadows = samplers.addDynamicSampler(shadowRenderTargets.getDepthTexture()::getTextureId, "shadowtex0", "shadow");
            usesShadows |= samplers.addDynamicSampler(shadowRenderTargets.getDepthTextureNoTranslucents()::getTextureId, "shadowtex1");
        }
        samplers.addDynamicSampler(() -> shadowRenderTargets.getColorTextureId(0), "shadowcolor", "shadowcolor0");
        samplers.addDynamicSampler(() -> shadowRenderTargets.getColorTextureId(1), "shadowcolor1");
        if (shadowRenderTargets.isHardwareFiltered(0)) {
            samplers.addDynamicSampler(shadowRenderTargets.getDepthTexture()::getTextureId, "shadowtex0HW");
        }
        if (shadowRenderTargets.isHardwareFiltered(1)) {
            samplers.addDynamicSampler(shadowRenderTargets.getDepthTextureNoTranslucents()::getTextureId, "shadowtex1HW");
        }
        return usesShadows;
    }

    public static void addLevelSamplers(SamplerHolder samplers, AbstractTexture normals, AbstractTexture specular, AbstractTexture whitePixel, InputAvailability availability) {
        if (availability.texture) {
            samplers.addExternalSampler(0, "tex", "texture", "gtexture");
        } else {
            samplers.addDynamicSampler(() -> ((AbstractTexture)whitePixel).m_117963_(), "tex", "texture", "gtexture", "gcolor", "colortex0");
        }
        if (availability.lightmap) {
            samplers.addExternalSampler(2, "lightmap");
        } else {
            samplers.addDynamicSampler(() -> ((AbstractTexture)whitePixel).m_117963_(), "lightmap");
        }
        if (availability.overlay) {
            samplers.addExternalSampler(1, "iris_overlay");
        } else {
            samplers.addDynamicSampler(() -> ((AbstractTexture)whitePixel).m_117963_(), "iris_overlay");
        }
        samplers.addDynamicSampler(() -> ((AbstractTexture)normals).m_117963_(), "normals");
        samplers.addDynamicSampler(() -> ((AbstractTexture)specular).m_117963_(), "specular");
    }

    public static void addWorldDepthSamplers(SamplerHolder samplers, RenderTargets renderTargets) {
        samplers.addDynamicSampler(renderTargets::getDepthTexture, "depthtex0");
        samplers.addDynamicSampler(renderTargets.getDepthTextureNoTranslucents()::getTextureId, "depthtex1");
    }

    public static void addCompositeSamplers(SamplerHolder samplers, RenderTargets renderTargets) {
        samplers.addDynamicSampler(renderTargets::getDepthTexture, "gdepthtex", "depthtex0");
        samplers.addDynamicSampler(renderTargets.getDepthTextureNoTranslucents()::getTextureId, "depthtex1");
        samplers.addDynamicSampler(renderTargets.getDepthTextureNoHand()::getTextureId, "depthtex2");
    }
}

