/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.lame4j;

import de.maxhenkel.lame4j.Audio;
import de.maxhenkel.lame4j.DecodedAudio;
import de.maxhenkel.lame4j.Lame;
import de.maxhenkel.lame4j.ShortArrayBuffer;
import de.maxhenkel.lame4j.UnknownPlatformException;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import javax.sound.sampled.AudioFormat;

public class Mp3Decoder
implements Audio,
AutoCloseable {
    private long decoder;
    private final InputStream inputStream;

    public Mp3Decoder(InputStream inputStream) throws IOException, UnknownPlatformException {
        Lame.load();
        this.inputStream = inputStream;
        this.decoder = Mp3Decoder.createDecoder();
    }

    private static native long createDecoder();

    private native short[] decodeNextFrame(InputStream var1) throws IOException;

    public short[] decodeNextFrame() throws IOException {
        return this.decodeNextFrame(this.inputStream);
    }

    public native boolean headerParsed();

    @Override
    public native int getChannelCount();

    @Override
    public native int getBitRate();

    @Override
    public native int getSampleRate();

    @Override
    @Nullable
    public AudioFormat createAudioFormat() {
        if (!this.headerParsed()) {
            return null;
        }
        return Audio.super.createAudioFormat();
    }

    private native void destroyDecoder();

    @Override
    public void close() throws IOException {
        this.destroyDecoder();
        this.decoder = 0L;
        this.inputStream.close();
    }

    public boolean isClosed() {
        return this.decoder == 0L;
    }

    public static DecodedAudio decode(InputStream inputStream) throws IOException, UnknownPlatformException {
        try (Mp3Decoder decoder = new Mp3Decoder(inputStream);){
            ShortArrayBuffer sampleBuffer = new ShortArrayBuffer(2048);
            while (true) {
                short[] samples;
                if ((samples = decoder.decodeNextFrame()) == null) {
                    if (sampleBuffer.size() > 0) break;
                    throw new IOException("No audio data found");
                }
                sampleBuffer.writeShorts(samples);
            }
            if (!decoder.headerParsed()) {
                throw new IOException("No header found");
            }
            DecodedAudio decodedAudio = new DecodedAudio(decoder.getChannelCount(), decoder.getSampleRate(), decoder.getBitRate(), sampleBuffer.toShortArray());
            return decodedAudio;
        }
    }
}

