/*
 * Decompiled with CFR 0.152.
 */
package dev.limonblaze.oriacs.common.item;

import dev.limonblaze.oriacs.common.OriacsServerConfig;
import dev.limonblaze.oriacs.common.item.DivingHelmetItem;
import dev.limonblaze.oriacs.common.item.OriacsArmorItem;
import dev.limonblaze.oriacs.common.item.OriacsArmorMaterials;
import dev.limonblaze.oriacs.common.registry.OriacsItems;
import io.github.apace100.origins.power.OriginsPowerTypes;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.factory.PowerFactory;
import io.github.edwinmindcraft.apoli.common.power.DummyPower;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class LandwalkingHelmetItem
extends OriacsArmorItem {
    public LandwalkingHelmetItem(Item.Properties properties) {
        super(OriacsArmorMaterials.DIVING, EquipmentSlot.HEAD, properties);
        CauldronInteraction.f_175606_.put(this, this::emptyCauldronInteraction);
    }

    public ItemStack transformToDiving(ItemStack original) {
        ItemStack transformed = ((DivingHelmetItem)((Object)OriacsItems.DIVING_HELMET.get())).m_7968_();
        transformed.m_41751_(original.m_41784_());
        return transformed;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (player.m_36341_()) {
            ItemStack original = player.m_21120_(hand);
            BlockHitResult hit = LandwalkingHelmetItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
            if (hit.m_6662_() == HitResult.Type.BLOCK) {
                Direction direction = hit.m_82434_();
                BlockPos pos = hit.m_82425_();
                BlockPos pos1 = pos.m_121945_(direction);
                if (level.m_7966_(player, pos) && player.m_36204_(pos1, direction, original)) {
                    BucketItem bucket;
                    LiquidBlockContainer container;
                    BlockState blockstate = level.m_8055_(pos);
                    Block block = blockstate.m_60734_();
                    pos = block instanceof LiquidBlockContainer && (container = (LiquidBlockContainer)block).m_6044_((BlockGetter)level, pos, blockstate, (Fluid)Fluids.f_76193_) ? pos : pos1;
                    block = Items.f_42447_;
                    if (block instanceof BucketItem && (bucket = (BucketItem)block).m_142073_(player, level, pos, hit)) {
                        ItemStack transformed = this.transformToDiving(original);
                        if (player instanceof ServerPlayer) {
                            CriteriaTriggers.f_10591_.m_59469_((ServerPlayer)player, pos, original);
                        }
                        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                        return InteractionResultHolder.m_19092_((Object)transformed, (boolean)level.m_5776_());
                    }
                }
            }
            return InteractionResultHolder.m_19098_((Object)original);
        }
        return super.m_7203_(level, player, hand);
    }

    public void onArmorTick(ItemStack stack, Level level, Player player) {
        if (!level.f_46443_ && player.f_19797_ % 20 == 0) {
            CompoundTag tag = stack.m_41784_();
            int progress = tag.m_128451_("TransformProgress");
            int respiration = stack.getEnchantmentLevel(Enchantments.f_44970_);
            if (!player.isEyeInFluidType(Fluids.f_76193_.getFluidType())) {
                if (IPowerContainer.hasPower((Entity)player, (PowerFactory)((DummyPower)OriginsPowerTypes.WATER_BREATHING.get()))) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19608_, 30, 0, true, false, true));
                }
                tag.m_128405_("TransformProgress", progress + 1);
            } else {
                tag.m_128405_("TransformProgress", Math.max(0, progress - 1));
            }
            if ((double)progress > (double)((Integer)OriacsServerConfig.CONFIG.LANDWALKING_HELMET_TRANSFORM_TIME.get()).intValue() * (1.0 + (double)respiration * (Double)OriacsServerConfig.CONFIG.LANDWALKING_HELMET_RESPIRATION_MULTIPLIER.get())) {
                tag.m_128405_("TransformProgress", 0);
                ItemStack transformed = this.transformToDiving(stack);
                player.m_8061_(EquipmentSlot.HEAD, transformed);
            }
        }
    }

    public boolean m_142305_(ItemStack stack, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (action != ClickAction.PRIMARY) {
            return false;
        }
        IFluidHandlerItem handler = (IFluidHandlerItem)other.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElse(null);
        if (handler == null) {
            return false;
        }
        FluidStack bucket = new FluidStack((Fluid)Fluids.f_76193_, 1000);
        if (handler.fill(bucket, IFluidHandler.FluidAction.SIMULATE) == 1000) {
            handler.fill(bucket, IFluidHandler.FluidAction.EXECUTE);
            slot.m_5852_(this.transformToDiving(stack));
            access.m_142104_(handler.getContainer());
            player.f_19853_.m_7785_(player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11781_, SoundSource.PLAYERS, 1.0f, 1.0f, false);
            return true;
        }
        return false;
    }

    public InteractionResult emptyCauldronInteraction(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack stack) {
        if (!level.f_46443_) {
            player.m_21008_(hand, this.transformToDiving(stack));
            player.m_36220_(Stats.f_12943_);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            level.m_46597_(pos, (BlockState)Blocks.f_152476_.m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(3)));
            level.m_5594_(null, pos, SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_142346_(null, GameEvent.f_157769_, pos);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }
}

