/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.stream.IntStream;
import net.mehvahdjukaar.supplementaries.common.inventories.IContainerProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public abstract class OpeneableContainerBlockEntity
extends RandomizableContainerBlockEntity
implements WorldlyContainer {
    private final ContainerOpenersCounter openersCounter = new ContainerCounter();
    protected NonNullList<ItemStack> items;

    protected OpeneableContainerBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state, int size) {
        super(blockEntityType, pos, state);
        this.items = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
    }

    public int m_6643_() {
        return this.items.size();
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(tag) && tag.m_128425_("Items", 9)) {
            ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (!this.m_59634_(tag)) {
            ContainerHelper.m_18976_((CompoundTag)tag, this.items, (boolean)false);
        }
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.items;
    }

    protected void m_6520_(NonNullList<ItemStack> itemsIn) {
        this.items = itemsIn;
    }

    public int[] m_7071_(Direction side) {
        return IntStream.range(0, this.m_6643_()).toArray();
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void m_5856_(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155452_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void m_5785_(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155468_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void recheckOpen() {
        if (!this.f_58859_) {
            this.openersCounter.m_155476_(this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    protected abstract void updateBlockState(BlockState var1, boolean var2);

    protected abstract void playOpenSound(BlockState var1);

    protected abstract void playCloseSound(BlockState var1);

    public boolean isUnused() {
        return this.openersCounter.m_155450_() == 0;
    }

    private class ContainerCounter
    extends ContainerOpenersCounter {
        private ContainerCounter() {
        }

        protected void m_142292_(Level level, BlockPos pos, BlockState state) {
            OpeneableContainerBlockEntity.this.playOpenSound(state);
            OpeneableContainerBlockEntity.this.updateBlockState(state, true);
        }

        protected void m_142289_(Level level, BlockPos pos, BlockState state) {
            OpeneableContainerBlockEntity.this.playCloseSound(state);
            OpeneableContainerBlockEntity.this.updateBlockState(state, false);
        }

        protected void m_142148_(Level level, BlockPos pos, BlockState state, int i, int i1) {
        }

        protected boolean m_142718_(Player player) {
            AbstractContainerMenu abstractContainerMenu = player.f_36096_;
            if (abstractContainerMenu instanceof IContainerProvider) {
                IContainerProvider chestMenu = (IContainerProvider)abstractContainerMenu;
                Container container = chestMenu.getContainer();
                return container == OpeneableContainerBlockEntity.this;
            }
            return false;
        }
    }
}

