/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.mixin.common.position_sync;

import java.util.Set;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerPositionPacket;
import net.minecraft.network.protocol.game.ServerboundAcceptTeleportationPacket;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.network.protocol.game.ServerboundMoveVehiclePacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.IPMcHelper;
import qouteall.imm_ptl.core.ducks.IEEntity;
import qouteall.imm_ptl.core.ducks.IEPlayerMoveC2SPacket;
import qouteall.imm_ptl.core.ducks.IEPlayerPositionLookS2CPacket;
import qouteall.imm_ptl.core.ducks.IEServerPlayNetworkHandler;
import qouteall.imm_ptl.core.miscellaneous.IPVanillaCopy;
import qouteall.q_misc_util.Helper;

@Mixin(value={ServerGamePacketListenerImpl.class}, priority=900)
public abstract class MixinServerGamePacketListenerImpl
implements IEServerPlayNetworkHandler {
    @Shadow
    public ServerPlayer f_9743_;
    @Shadow
    private Vec3 f_9766_;
    @Shadow
    private int f_9767_;
    @Shadow
    private int f_9735_;
    @Shadow
    private int f_9746_;
    @Shadow
    private double f_9763_;
    @Shadow
    private double f_9764_;
    @Shadow
    private double f_9765_;
    @Shadow
    private double f_9760_;
    @Shadow
    private double f_9761_;
    @Shadow
    private double f_9762_;
    @Shadow
    @Final
    public Connection f_9742_;
    @Shadow
    @Final
    private MinecraftServer f_9745_;
    @Shadow
    private Entity f_9759_;
    @Shadow
    private boolean f_9738_;

    @Shadow
    protected abstract boolean m_9956_();

    @Shadow
    protected abstract boolean m_9795_(LevelReader var1, AABB var2);

    @Shadow
    public abstract void m_9942_(Component var1);

    @Inject(method={"Lnet/minecraft/server/network/ServerGamePacketListenerImpl;handleMovePlayer(Lnet/minecraft/network/protocol/game/ServerboundMovePlayerPacket;)V"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/network/protocol/PacketUtils;ensureRunningOnSameThread(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/PacketListener;Lnet/minecraft/server/level/ServerLevel;)V")}, cancellable=true)
    private void onProcessMovePacket(ServerboundMovePlayerPacket packet, CallbackInfo ci) {
        ResourceKey<Level> packetDimension = ((IEPlayerMoveC2SPacket)packet).getPlayerDimension();
        if (packetDimension == null) {
            Helper.err("Player move packet is missing dimension info. Maybe the player client doesn't have ImmPtl");
            IPGlobal.serverTaskList.addTask(() -> {
                this.f_9743_.f_8906_.m_9942_((Component)Component.m_237113_((String)"The client does not have Immersive Portals mod"));
                return true;
            });
            return;
        }
        if (IPGlobal.serverTeleportationManager.isJustTeleported((Entity)this.f_9743_, 100L)) {
            this.cancelTeleportRequest();
        }
        if (this.f_9743_.f_19853_.m_46472_() != packetDimension) {
            IPGlobal.serverTaskList.addTask(() -> {
                IPGlobal.serverTeleportationManager.acceptDubiousMovePacket(this.f_9743_, packet, packetDimension);
                return true;
            });
            ci.cancel();
        }
    }

    @Redirect(method={"Lnet/minecraft/server/network/ServerGamePacketListenerImpl;handleMovePlayer(Lnet/minecraft/network/protocol/game/ServerboundMovePlayerPacket;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerGamePacketListenerImpl;isSingleplayerOwner()Z"))
    private boolean redirectIsServerOwnerOnPlayerMove(ServerGamePacketListenerImpl serverPlayNetworkHandler) {
        if (MixinServerGamePacketListenerImpl.shouldAcceptDubiousMovement(this.f_9743_)) {
            return true;
        }
        return this.m_9956_();
    }

    @Redirect(method={"Lnet/minecraft/server/network/ServerGamePacketListenerImpl;handleMovePlayer(Lnet/minecraft/network/protocol/game/ServerboundMovePlayerPacket;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;isChangingDimension()Z"), require=0)
    private boolean redirectIsInTeleportationState(ServerPlayer player) {
        if (MixinServerGamePacketListenerImpl.shouldAcceptDubiousMovement(player)) {
            return true;
        }
        return player.m_8958_();
    }

    @Overwrite
    @IPVanillaCopy
    public void m_143617_(double x, double y, double z, float yaw, float pitch, Set<ClientboundPlayerPositionPacket.RelativeArgument> flags, boolean shouldDismount) {
        if (this.f_9743_.m_146911_() != null) {
            Helper.err("Tries to send player pos packet to a removed player");
            new Throwable().printStackTrace();
            return;
        }
        double d = flags.contains(ClientboundPlayerPositionPacket.RelativeArgument.X) ? this.f_9743_.m_20185_() : 0.0;
        double e = flags.contains(ClientboundPlayerPositionPacket.RelativeArgument.Y) ? this.f_9743_.m_20186_() : 0.0;
        double f = flags.contains(ClientboundPlayerPositionPacket.RelativeArgument.Z) ? this.f_9743_.m_20189_() : 0.0;
        float g = flags.contains(ClientboundPlayerPositionPacket.RelativeArgument.Y_ROT) ? this.f_9743_.m_146908_() : 0.0f;
        float h = flags.contains(ClientboundPlayerPositionPacket.RelativeArgument.X_ROT) ? this.f_9743_.m_146909_() : 0.0f;
        this.f_9766_ = new Vec3(x, y, z);
        if (++this.f_9767_ == Integer.MAX_VALUE) {
            this.f_9767_ = 0;
        }
        this.f_9735_ = this.f_9746_;
        this.f_9743_.m_19890_(x, y, z, yaw, pitch);
        ClientboundPlayerPositionPacket lookPacket = new ClientboundPlayerPositionPacket(x - d, y - e, z - f, yaw - g, pitch - h, flags, this.f_9767_, shouldDismount);
        ((IEPlayerPositionLookS2CPacket)lookPacket).setPlayerDimension((ResourceKey<Level>)this.f_9743_.f_19853_.m_46472_());
        this.f_9743_.f_8906_.m_9829_((Packet)lookPacket);
    }

    @Redirect(method={"Lnet/minecraft/server/network/ServerGamePacketListenerImpl;handleMovePlayer(Lnet/minecraft/network/protocol/game/ServerboundMovePlayerPacket;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerGamePacketListenerImpl;isPlayerCollidingWithAnythingNew(Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/world/phys/AABB;)Z"))
    private boolean onCheckPlayerCollision(ServerGamePacketListenerImpl serverPlayNetworkHandler, LevelReader worldView, AABB box) {
        if (IPGlobal.serverTeleportationManager.isJustTeleported((Entity)this.f_9743_, 100L)) {
            return false;
        }
        if (((IEEntity)this.f_9743_).getCollidingPortal() != null) {
            return false;
        }
        boolean portalsNearby = IPMcHelper.getNearbyPortals((Entity)this.f_9743_, 16.0).findAny().isPresent();
        if (portalsNearby) {
            return false;
        }
        return this.m_9795_(worldView, box);
    }

    @Inject(method={"Lnet/minecraft/server/network/ServerGamePacketListenerImpl;handleAcceptTeleportPacket(Lnet/minecraft/network/protocol/game/ServerboundAcceptTeleportationPacket;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onOnTeleportConfirm(ServerboundAcceptTeleportationPacket packet, CallbackInfo ci) {
        if (this.f_9766_ == null) {
            ci.cancel();
        }
    }

    @Inject(method={"Lnet/minecraft/server/network/ServerGamePacketListenerImpl;handleMoveVehicle(Lnet/minecraft/network/protocol/game/ServerboundMoveVehiclePacket;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerGamePacketListenerImpl;containsInvalidValues(DDDFF)Z")}, cancellable=true)
    private void onOnVehicleMove(ServerboundMoveVehiclePacket packet, CallbackInfo ci) {
        if (IPGlobal.serverTeleportationManager.isJustTeleported((Entity)this.f_9743_, 40L)) {
            Entity entity = this.f_9743_.m_20201_();
            if (entity != this.f_9743_) {
                double currX = entity.m_20185_();
                double currY = entity.m_20186_();
                double currZ = entity.m_20189_();
                double newX = packet.m_134199_();
                double newY = packet.m_134202_();
                double newZ = packet.m_134203_();
                if (entity.m_20182_().m_82531_(newX, newY, newZ) < 256.0) {
                    float yaw = packet.m_134204_();
                    float pitch = packet.m_134205_();
                    entity.m_19890_(newX, newY, newZ, yaw, pitch);
                    this.f_9743_.m_9236_().m_7726_().m_8385_(this.f_9743_);
                    this.f_9738_ = false;
                    this.f_9763_ = entity.m_20185_();
                    this.f_9764_ = entity.m_20186_();
                    this.f_9765_ = entity.m_20189_();
                }
            }
            ci.cancel();
        }
    }

    private static boolean shouldAcceptDubiousMovement(ServerPlayer player) {
        if (IPGlobal.serverTeleportationManager.isJustTeleported((Entity)player, 100L)) {
            return true;
        }
        if (IPGlobal.looseMovementCheck) {
            return true;
        }
        if (((IEEntity)player).getCollidingPortal() != null) {
            return true;
        }
        boolean portalsNearby = IPMcHelper.getNearbyPortals((Entity)player, 16.0).findFirst().isPresent();
        return portalsNearby;
    }

    @Override
    public void cancelTeleportRequest() {
        this.f_9766_ = null;
    }
}

