/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.platform_specific;

import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.client.multiplayer.ClientChunkCache;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import qouteall.imm_ptl.core.chunk_loading.MyClientChunkManager;
import qouteall.imm_ptl.core.platform_specific.IPConfig;
import qouteall.imm_ptl.core.platform_specific.RequiemCompat;
import qouteall.imm_ptl.core.portal.custom_portal_gen.PortalGenInfo;
import qouteall.q_misc_util.Helper;

public class O_O {
    public static boolean isDimensionalThreadingPresent = false;
    private static final BlockState obsidianState = Blocks.f_50080_.m_49966_();

    public static boolean isForge() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onPlayerChangeDimensionClient(ResourceKey<Level> from, ResourceKey<Level> to) {
        RequiemCompat.onPlayerTeleportedClient();
    }

    public static void onPlayerTravelOnServer(ServerPlayer player, ResourceKey<Level> from, ResourceKey<Level> to) {
        RequiemCompat.onPlayerTeleportedServer(player);
    }

    public static void loadConfigFabric() {
        Helper.log("Loading Immersive Portals config");
        IPConfig ipConfig = IPConfig.readConfig();
        ipConfig.onConfigChanged();
        ipConfig.saveConfigFile();
    }

    public static void onServerConstructed() {
    }

    public static boolean isObsidian(BlockState blockState) {
        return blockState == obsidianState;
    }

    public static void postClientChunkLoadEvent(LevelChunk chunk) {
        MinecraftForge.EVENT_BUS.post((Event)new ChunkEvent.Load((ChunkAccess)chunk));
    }

    public static void postClientChunkUnloadEvent(LevelChunk chunk) {
        MinecraftForge.EVENT_BUS.post((Event)new ChunkEvent.Unload((ChunkAccess)chunk));
    }

    public static boolean isDedicatedServer() {
        return FMLEnvironment.dist == Dist.DEDICATED_SERVER;
    }

    public static void postPortalSpawnEventForge(PortalGenInfo info) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ClientChunkCache createMyClientChunkManager(ClientLevel world, int loadDistance) {
        return new MyClientChunkManager(world, loadDistance);
    }

    public static boolean getIsPehkuiPresent() {
        return ModList.get().isLoaded("pehkui");
    }

    @Nullable
    public static String getImmPtlModInfoUrl() {
        String gameVersion = SharedConstants.m_183709_().getName();
        int lastDotIndex = gameVersion.lastIndexOf(46);
        String majorGameVersion = gameVersion.substring(0, lastDotIndex);
        return "https://qouteall.fun/immptl_info/%s.x.json".formatted(majorGameVersion);
    }

    public static boolean isModLoadedWithinVersion(String modId, @Nullable String startVersion, @Nullable String endVersion) {
        if (ModList.get().isLoaded(modId)) {
            int i;
            ArtifactVersion version = ((ModContainer)ModList.get().getModContainerById(modId).get()).getModInfo().getVersion();
            if (startVersion != null && (i = version.compareTo((Object)new DefaultArtifactVersion(startVersion))) < 0) {
                return false;
            }
            return endVersion == null || (i = version.compareTo((Object)new DefaultArtifactVersion(endVersion))) <= 0;
        }
        return false;
    }

    public static String getModDownloadLink() {
        return "https://www.curseforge.com/minecraft/mc-mods/immersive-portals-mod";
    }
}

