/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.platform_specific;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.Validate;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.compat.PehkuiInterface;
import qouteall.imm_ptl.core.ducks.IECamera;
import qouteall.imm_ptl.core.portal.Portal;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleTypes;
import virtuoel.pehkui.util.ScaleUtils;

public class PehkuiInterfaceInitializer {
    public static void init() {
        PehkuiInterface.invoker = new OnPehkuiPresent();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void onPlayerTeleportedClient(Portal portal) {
        if (portal.hasScaling() && portal.teleportChangesScale) {
            Minecraft client = Minecraft.m_91087_();
            LocalPlayer player = client.f_91074_;
            Validate.notNull((Object)player);
            PehkuiInterfaceInitializer.doScalingForEntity((Entity)player, portal);
            IECamera camera = (IECamera)client.f_91063_.m_109153_();
            camera.setCameraY((float)((double)camera.getCameraY() * portal.scaling), (float)((double)camera.getLastCameraY() * portal.scaling));
        }
    }

    private static void onEntityTeleportedServer(Entity entity, Portal portal) {
        if (portal.hasScaling() && portal.teleportChangesScale) {
            PehkuiInterfaceInitializer.doScalingForEntity(entity, portal);
            if (entity.m_20202_() != null) {
                PehkuiInterfaceInitializer.doScalingForEntity(entity.m_20202_(), portal);
            }
        }
    }

    private static void doScalingForEntity(Entity entity, Portal portal) {
        Vec3 eyePos = McHelper.getEyePos(entity);
        Vec3 lastTickEyePos = McHelper.getLastTickEyePos(entity);
        float oldScale = PehkuiInterface.invoker.getBaseScale(entity);
        float newScale = PehkuiInterfaceInitializer.transformScale(portal, oldScale);
        if (!entity.f_19853_.f_46443_ && PehkuiInterfaceInitializer.isScaleIllegal(newScale)) {
            newScale = 1.0f;
            entity.m_213846_((Component)Component.m_237113_((String)"Scale out of range"));
        }
        PehkuiInterface.invoker.setBaseScale(entity, newScale);
        if (!entity.f_19853_.f_46443_) {
            McHelper.setEyePos(entity, eyePos, lastTickEyePos);
            McHelper.updateBoundingBox(entity);
            float scaleTest = ScaleUtils.getEyeHeightScale((Entity)entity, (float)0.5f);
            Validate.isTrue(((double)scaleTest > 1.0E-4 ? 1 : 0) != 0);
        } else {
            McHelper.setEyePos(entity, eyePos, lastTickEyePos);
            McHelper.updateBoundingBox(entity);
        }
    }

    private static float transformScale(Portal portal, float oldScale) {
        float result = (float)((double)oldScale * portal.scaling);
        if (Math.abs(result - 1.0f) < 1.0E-4f) {
            result = 1.0f;
        }
        return result;
    }

    private static boolean isScaleIllegal(float scale) {
        return scale > (float)IPGlobal.scaleLimit || scale < 1.0f / (float)(IPGlobal.scaleLimit * 2);
    }

    public static class OnPehkuiPresent
    extends PehkuiInterface.Invoker {
        private boolean loggedErrorMessage = false;

        @Override
        public boolean isPehkuiPresent() {
            return true;
        }

        @Override
        public void onClientPlayerTeleported(Portal portal) {
            PehkuiInterfaceInitializer.onPlayerTeleportedClient(portal);
        }

        @Override
        public void onServerEntityTeleported(Entity entity, Portal portal) {
            PehkuiInterfaceInitializer.onEntityTeleportedServer(entity, portal);
        }

        private void logErrorMessage(Entity entity, Throwable e, String situation) {
            e.printStackTrace();
            entity.m_213846_((Component)Component.m_237113_((String)("Something went wrong with Pehkui (" + situation + ")")));
        }

        @Override
        public float getBaseScale(Entity entity, float tickDelta) {
            try {
                return ScaleTypes.BASE.getScaleData(entity).getBaseScale(tickDelta);
            }
            catch (Throwable e) {
                if (!this.loggedErrorMessage) {
                    this.loggedErrorMessage = true;
                    this.logErrorMessage(entity, e, "getting scale");
                }
                return super.getBaseScale(entity, tickDelta);
            }
        }

        @Override
        public void setBaseScale(Entity entity, float scale) {
            block2: {
                try {
                    ScaleData data = ScaleTypes.BASE.getScaleData(entity);
                    data.setScale(scale);
                }
                catch (Throwable e) {
                    if (this.loggedErrorMessage) break block2;
                    this.loggedErrorMessage = true;
                    this.logErrorMessage(entity, e, "setting scale");
                }
            }
        }

        @Override
        public float computeThirdPersonScale(Entity entity, float tickDelta) {
            try {
                return ScaleTypes.THIRD_PERSON.getScaleData(entity).getScale(tickDelta);
            }
            catch (Throwable e) {
                if (!this.loggedErrorMessage) {
                    this.loggedErrorMessage = true;
                    this.logErrorMessage(entity, e, "getting third person scale");
                }
                return super.computeThirdPersonScale(entity, tickDelta);
            }
        }

        @Override
        public float computeBlockReachScale(Entity entity, float tickDelta) {
            try {
                return ScaleTypes.BLOCK_REACH.getScaleData(entity).getScale(tickDelta);
            }
            catch (Throwable e) {
                if (!this.loggedErrorMessage) {
                    this.loggedErrorMessage = true;
                    this.logErrorMessage(entity, e, "getting reach scale");
                }
                return super.computeBlockReachScale(entity, tickDelta);
            }
        }

        @Override
        public float computeMotionScale(Entity entity, float tickDelta) {
            try {
                return ScaleTypes.MOTION.getScaleData(entity).getScale(tickDelta);
            }
            catch (Throwable e) {
                if (!this.loggedErrorMessage) {
                    this.loggedErrorMessage = true;
                    this.logErrorMessage(entity, e, "getting motion scale");
                }
                return super.computeMotionScale(entity, tickDelta);
            }
        }
    }
}

