/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.platform_specific.forge.networking;

import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import qouteall.imm_ptl.core.portal.global_portals.GlobalPortalStorage;
import qouteall.q_misc_util.dimension.DimId;

public class GlobalPortalUpdate {
    private ResourceKey<Level> dimension;
    private CompoundTag compoundTag;

    public GlobalPortalUpdate(GlobalPortalStorage storage) {
        this.dimension = ((ServerLevel)storage.world.get()).m_46472_();
        this.compoundTag = storage.m_7176_(new CompoundTag());
    }

    public GlobalPortalUpdate(FriendlyByteBuf buf) {
        this.dimension = DimId.readWorldId(buf, true);
        this.compoundTag = buf.m_130260_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        DimId.writeWorldId(buf, this.dimension, false);
        buf.m_130079_(this.compoundTag);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> GlobalPortalStorage.receiveGlobalPortalSync(this.dimension, this.compoundTag));
        ctx.setPacketHandled(true);
        return true;
    }
}

