/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import qouteall.q_misc_util.Helper;

public class GeometryPortalShape {
    public List<TriangleInPlane> triangles = new ArrayList<TriangleInPlane>();

    private static boolean isOnLeftSideOfTheLine(double x, double y, double x1, double y1, double x2, double y2) {
        return GeometryPortalShape.crossProduct2D(x - x1, x2 - x1, y - y1, y2 - y1) >= 0.0;
    }

    private static double crossProduct2D(double x1, double y1, double x2, double y2) {
        return x1 * y2 - x2 * y1;
    }

    public GeometryPortalShape() {
    }

    public GeometryPortalShape(ListTag tag) {
        int size = tag.size();
        if (size % 6 != 0) {
            Helper.err("Bad Portal Shape Data " + tag);
            return;
        }
        int triangleNum = size / 6;
        for (int i = 0; i < triangleNum; ++i) {
            this.triangles.add(new TriangleInPlane(tag.m_128772_(i * 6 + 0), tag.m_128772_(i * 6 + 1), tag.m_128772_(i * 6 + 2), tag.m_128772_(i * 6 + 3), tag.m_128772_(i * 6 + 4), tag.m_128772_(i * 6 + 5)));
        }
    }

    public ListTag writeToTag() {
        ListTag tag = new ListTag();
        for (TriangleInPlane triangle : this.triangles) {
            tag.add((Object)DoubleTag.m_128500_((double)triangle.x1));
            tag.add((Object)DoubleTag.m_128500_((double)triangle.y1));
            tag.add((Object)DoubleTag.m_128500_((double)triangle.x2));
            tag.add((Object)DoubleTag.m_128500_((double)triangle.y2));
            tag.add((Object)DoubleTag.m_128500_((double)triangle.x3));
            tag.add((Object)DoubleTag.m_128500_((double)triangle.y3));
        }
        return tag;
    }

    public void addTriangleForRectangle(double x1, double y1, double x2, double y2) {
        this.triangles.add(new TriangleInPlane(x1, y1, x2, y1, x2, y2));
        this.triangles.add(new TriangleInPlane(x2, y2, x1, y2, x1, y1));
    }

    public boolean isValid() {
        if (this.triangles.isEmpty()) {
            return false;
        }
        return this.triangles.stream().allMatch(triangleInPlane -> triangleInPlane.getArea() > 0.001);
    }

    public static class TriangleInPlane {
        public double x1;
        public double y1;
        public double x2;
        public double y2;
        public double x3;
        public double y3;

        public TriangleInPlane(double x1, double y1, double x2, double y2, double x3, double y3) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            this.x3 = x3;
            this.y3 = y3;
            if (!this.isCounterClockWise()) {
                this.x2 = x3;
                this.y2 = y3;
                this.x3 = x2;
                this.y3 = y2;
                assert (this.isCounterClockWise());
            }
        }

        public boolean isCounterClockWise() {
            return GeometryPortalShape.isOnLeftSideOfTheLine(this.x3, this.y3, this.x1, this.y1, this.x2, this.y2);
        }

        public boolean isPointInTriangle(double x, double y) {
            assert (this.isCounterClockWise());
            return GeometryPortalShape.isOnLeftSideOfTheLine(x, y, this.x1, this.y1, this.x2, this.y2) && GeometryPortalShape.isOnLeftSideOfTheLine(x, y, this.x2, this.y2, this.x3, this.y3) && GeometryPortalShape.isOnLeftSideOfTheLine(x, y, this.x3, this.y3, this.x1, this.y1);
        }

        public double getArea() {
            return GeometryPortalShape.crossProduct2D(this.x2 - this.x1, this.y2 - this.y1, this.x3 - this.x1, this.y3 - this.y1) / -2.0;
        }
    }
}

