/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.render.context_management;

import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.Validate;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.portal.Mirror;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalLike;
import qouteall.imm_ptl.core.render.PortalRenderer;
import qouteall.imm_ptl.core.render.context_management.RenderStates;

@OnlyIn(value=Dist.CLIENT)
public class PortalRendering {
    private static final Stack<PortalLike> portalLayers = new Stack();
    private static boolean isRenderingCache = false;
    private static boolean isRenderingOddNumberOfMirrorsCache = false;

    public static void pushPortalLayer(PortalLike portal) {
        portalLayers.push(portal);
        PortalRendering.updateCache();
    }

    public static void popPortalLayer() {
        portalLayers.pop();
        PortalRendering.updateCache();
    }

    private static void updateCache() {
        isRenderingCache = PortalRendering.getPortalLayer() != 0;
        int mirrorNum = 0;
        for (PortalLike portal : portalLayers) {
            if (!(portal instanceof Mirror)) continue;
            ++mirrorNum;
        }
        isRenderingOddNumberOfMirrorsCache = mirrorNum % 2 == 1;
    }

    public static int getPortalLayer() {
        return portalLayers.size();
    }

    public static boolean isRendering() {
        return isRenderingCache;
    }

    public static boolean isRenderingOddNumberOfMirrors() {
        return isRenderingOddNumberOfMirrorsCache;
    }

    public static int getMaxPortalLayer() {
        if (RenderStates.isLaggy) {
            return 1;
        }
        return IPGlobal.maxPortalLayer;
    }

    public static PortalLike getRenderingPortal() {
        return portalLayers.peek();
    }

    public static void onBeginPortalWorldRendering() {
        List currRenderInfo = portalLayers.stream().map(WeakReference::new).collect(Collectors.toList());
        RenderStates.portalRenderInfos.add(currRenderInfo);
        ++RenderStates.portalsRenderedThisFrame;
        if (portalLayers.stream().anyMatch(PortalLike::hasScaling)) {
            RenderStates.renderedScalingPortal = true;
        }
        CHelper.checkGlError();
    }

    public static void onEndPortalWorldRendering() {
        RenderStates.renderedDimensions.add(portalLayers.peek().getDestDim());
    }

    public static Vec3 getRenderingCameraPos() {
        Vec3 pos = RenderStates.originalCamera.m_90583_();
        for (PortalLike portal : portalLayers) {
            pos = portal.transformPoint(pos);
        }
        return pos;
    }

    public static double getExtraModelViewScaling() {
        double scale = 1.0;
        for (PortalLike portal : portalLayers) {
            if (PortalRenderer.shouldApplyScaleToModelView(portal)) continue;
            scale *= portal.getScale();
        }
        return scale;
    }

    @Nullable
    public static BlockPos getCaveCullingStartingPoint() {
        Validate.isTrue((boolean)PortalRendering.isRendering());
        PortalLike renderingPortal = PortalRendering.getRenderingPortal();
        if (!(renderingPortal instanceof Portal)) {
            return null;
        }
        Portal portal = (Portal)renderingPortal;
        Minecraft mc = Minecraft.m_91087_();
        Vec3 cameraPos = CHelper.getCurrentCameraPos();
        Vec3 outerCameraPos = portal.inverseTransformPoint(cameraPos);
        Vec3 nearestPoint = portal.getNearestPointInPortal(outerCameraPos);
        nearestPoint = nearestPoint.m_82549_(portal.getNormal().m_82490_(1.0E-5));
        Vec3 result = portal.transformPoint(nearestPoint);
        return new BlockPos(result);
    }

    public static boolean shouldEnableSodiumCaveCulling() {
        if (PortalRendering.isRendering()) {
            Vec3 currentCameraPos;
            Vec3 originalCameraPos;
            PortalLike renderingPortal = PortalRendering.getRenderingPortal();
            double distance = renderingPortal.getDistanceToNearestPointInPortal(originalCameraPos = renderingPortal.inverseTransformPoint(currentCameraPos = CHelper.getCurrentCameraPos()));
            return distance < 5.0;
        }
        return false;
    }
}

