/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.teleportation;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.ducks.IEEntity;
import qouteall.imm_ptl.core.miscellaneous.IPVanillaCopy;
import qouteall.imm_ptl.core.mixin.common.collision.IEEntity_Collision;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalLike;
import qouteall.imm_ptl.core.portal.global_portals.GlobalPortalStorage;
import qouteall.imm_ptl.core.render.PortalGroup;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.my_util.LimitedLogger;

public class CollisionHelper {
    private static final LimitedLogger limitedLogger = new LimitedLogger(20);
    private static boolean thisTickStagnate = false;
    private static boolean lastTickStagnate = false;

    @Nullable
    private static AABB clipBox(AABB box, Vec3 planePos, Vec3 planeNormal) {
        boolean isPushedPosInFrontOfPlane;
        boolean xForward = planeNormal.f_82479_ > 0.0;
        boolean yForward = planeNormal.f_82480_ > 0.0;
        boolean zForward = planeNormal.f_82481_ > 0.0;
        Vec3 pushedPos = new Vec3(xForward ? box.f_82288_ : box.f_82291_, yForward ? box.f_82289_ : box.f_82292_, zForward ? box.f_82290_ : box.f_82293_);
        Vec3 staticPos = new Vec3(xForward ? box.f_82291_ : box.f_82288_, yForward ? box.f_82292_ : box.f_82289_, zForward ? box.f_82293_ : box.f_82290_);
        double tOfPushedPos = Helper.getCollidingT(planePos, planeNormal, pushedPos, planeNormal);
        boolean bl = isPushedPosInFrontOfPlane = tOfPushedPos < 0.0;
        if (isPushedPosInFrontOfPlane) {
            return box;
        }
        boolean isStaticPosInFrontOfPlane = Helper.isInFrontOfPlane(staticPos, planePos, planeNormal);
        if (!isStaticPosInFrontOfPlane) {
            return null;
        }
        Vec3 afterBeingPushed = pushedPos.m_82549_(planeNormal.m_82490_(tOfPushedPos));
        return new AABB(afterBeingPushed, staticPos);
    }

    public static boolean isBoxFullyBehindPlane(Vec3 planePos, Vec3 planeNormal, AABB box) {
        boolean xForward = planeNormal.f_82479_ > 0.0;
        boolean yForward = planeNormal.f_82480_ > 0.0;
        boolean zForward = planeNormal.f_82481_ > 0.0;
        Vec3 testingPos = new Vec3(xForward ? box.f_82291_ : box.f_82288_, yForward ? box.f_82292_ : box.f_82289_, zForward ? box.f_82293_ : box.f_82290_);
        return testingPos.m_82546_(planePos).m_82526_(planeNormal) < 0.0;
    }

    public static boolean canCollideWithPortal(Entity entity, Portal portal, float partialTick) {
        Vec3 cameraPosVec;
        if (portal.canTeleportEntity(entity) && portal.isInFrontOfPortal(cameraPosVec = entity.m_20299_(partialTick))) {
            boolean isInGroup;
            PortalLike collisionHandlingUnit = CollisionHelper.getCollisionHandlingUnit(portal);
            boolean bl = isInGroup = collisionHandlingUnit != portal;
            if (isInGroup) {
                return true;
            }
            if (portal.isPointInPortalProjection(cameraPosVec)) {
                return true;
            }
        }
        return false;
    }

    public static Vec3 handleCollisionHalfwayInPortal(Entity entity, Vec3 attemptedMove, Portal collidingPortal) {
        entity.f_19853_.m_46473_().m_6180_("cross_portal_collision");
        AABB originalBoundingBox = entity.m_20191_();
        Vec3 thisSideMove = CollisionHelper.getThisSideMove(entity, attemptedMove, collidingPortal, originalBoundingBox);
        Vec3 otherSideMove = CollisionHelper.getOtherSideMove(entity, thisSideMove, collidingPortal, originalBoundingBox, 1);
        entity.f_19853_.m_46473_().m_7238_();
        return new Vec3(CollisionHelper.correctXZCoordinate(attemptedMove.f_82479_, otherSideMove.f_82479_), CollisionHelper.correctYCoordinate(attemptedMove.f_82480_, otherSideMove.f_82480_), CollisionHelper.correctXZCoordinate(attemptedMove.f_82481_, otherSideMove.f_82481_));
    }

    private static double absMin(double a, double b) {
        return Math.abs(a) < Math.abs(b) ? a : b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Vec3 getOtherSideMove(Entity entity, Vec3 attemptedMove, Portal collidingPortal, AABB originalBoundingBox, int portalLayer) {
        if (portalLayer >= 100) {
            return attemptedMove;
        }
        if (!collidingPortal.getHasCrossPortalCollision()) {
            return attemptedMove;
        }
        Vec3 transformedAttemptedMove = collidingPortal.transformLocalVec(attemptedMove);
        AABB boxOtherSide = CollisionHelper.transformBox(collidingPortal, originalBoundingBox);
        if (boxOtherSide == null) {
            return attemptedMove;
        }
        Level destinationWorld = collidingPortal.getDestWorld();
        if (!destinationWorld.m_46805_(new BlockPos(boxOtherSide.m_82399_()))) {
            Vec3 innerDirection;
            if (entity instanceof Player && entity.f_19853_.m_5776_()) {
                CollisionHelper.informClientStagnant();
            }
            if (attemptedMove.m_82526_(innerDirection = collidingPortal.getNormal().m_82490_(-1.0)) < 0.0) {
                return attemptedMove;
            }
            return attemptedMove.m_82546_(innerDirection.m_82490_(innerDirection.m_82526_(attemptedMove)));
        }
        List<Portal> indirectCollidingPortals = McHelper.findEntitiesByBox(Portal.class, collidingPortal.getDestinationWorld(), boxOtherSide.m_82369_(transformedAttemptedMove), 8.0, p -> p.getHasCrossPortalCollision() && CollisionHelper.canCollideWithPortal(entity, p, 0.0f) && !Portal.isReversePortal(collidingPortal, p) && !Portal.isParallelPortal(collidingPortal, p) && Portal.isFlippedPortal(collidingPortal, p));
        Level oldWorld = entity.f_19853_;
        Vec3 oldPos = entity.m_20182_();
        Vec3 oldLastTickPos = McHelper.lastTickPosOf(entity);
        float oldStepHeight = entity.f_19793_;
        entity.f_19853_ = destinationWorld;
        entity.m_20011_(boxOtherSide);
        if (collidingPortal.getScale() > 1.0) {
            entity.f_19793_ = (float)((double)oldStepHeight * collidingPortal.getScale() * 1.01);
        }
        try {
            Vec3 result;
            if (!indirectCollidingPortals.isEmpty()) {
                Vec3 vec3 = CollisionHelper.getOtherSideMove(entity, transformedAttemptedMove, indirectCollidingPortals.get(0), entity.m_20191_(), portalLayer + 1);
                return vec3;
            }
            Vec3 collided = CollisionHelper.handleCollisionWithClipping(entity, transformedAttemptedMove, collidingPortal.getDestPos(), collidingPortal.getContentDirection());
            collided = new Vec3(CollisionHelper.correctXZCoordinate(transformedAttemptedMove.f_82479_, collided.f_82479_), CollisionHelper.correctYCoordinate(transformedAttemptedMove.f_82480_, collided.f_82480_), CollisionHelper.correctXZCoordinate(transformedAttemptedMove.f_82481_, collided.f_82481_));
            Vec3 vec3 = result = collidingPortal.inverseTransformLocalVec(collided);
            return vec3;
        }
        finally {
            entity.f_19853_ = oldWorld;
            McHelper.setPosAndLastTickPos(entity, oldPos, oldLastTickPos);
            entity.m_20011_(originalBoundingBox);
            entity.f_19793_ = oldStepHeight;
        }
    }

    private static double correctXZCoordinate(double attemptedMove, double result) {
        if (Math.abs(attemptedMove - result) < 0.001) {
            return attemptedMove;
        }
        if (Math.abs(result) < 1.0E-4) {
            return 0.0;
        }
        if (Math.abs(result) > Math.abs(attemptedMove) + 0.01) {
            return result;
        }
        return result * 0.999;
    }

    private static double correctYCoordinate(double attemptedMove, double result) {
        if (Math.abs(attemptedMove - result) < 0.001) {
            return attemptedMove;
        }
        if (Math.abs(result) < 1.0E-4) {
            return 0.0;
        }
        if (Math.abs(result) > Math.abs(attemptedMove) + 0.01) {
            return result;
        }
        if (result < 0.0) {
            return result * 0.999;
        }
        return result;
    }

    private static Vec3 getThisSideMove(Entity entity, Vec3 attemptedMove, Portal collidingPortal, AABB originalBoundingBox) {
        Vec3 clippingPlanePos = collidingPortal.getOriginPos();
        Vec3 clippingPlaneNormal = collidingPortal.getNormal();
        return CollisionHelper.handleCollisionWithClipping(entity, attemptedMove, clippingPlanePos, clippingPlaneNormal);
    }

    @IPVanillaCopy
    private static Vec3 handleCollisionWithClipping(Entity entity, Vec3 attemptedMove, Vec3 clippingPlanePos, Vec3 clippingPlaneNormal) {
        boolean touchGround;
        Function<VoxelShape, VoxelShape> filter = shape -> {
            AABB shapeBoundingBox = shape.m_83215_();
            boolean boxBehindPlane = CollisionHelper.isBoxFullyBehindPlane(clippingPlanePos, clippingPlaneNormal, shapeBoundingBox);
            if (boxBehindPlane) {
                return null;
            }
            boolean isFullyInFrontOfPlane = CollisionHelper.isBoxFullyBehindPlane(clippingPlanePos, clippingPlaneNormal.m_82490_(-1.0), shapeBoundingBox);
            if (isFullyInFrontOfPlane) {
                return shape;
            }
            AABB clippedBoundingBox = CollisionHelper.clipBox(shapeBoundingBox, clippingPlanePos, clippingPlaneNormal);
            if (clippedBoundingBox == null) {
                return null;
            }
            VoxelShape result = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83064_((AABB)clippedBoundingBox), (BooleanOp)BooleanOp.f_82689_);
            return result;
        };
        AABB boundingBox = entity.m_20191_();
        List entityCollisions = entity.f_19853_.m_183134_(entity, boundingBox.m_82369_(attemptedMove));
        Vec3 collidedMovement = attemptedMove.m_82556_() == 0.0 ? attemptedMove : CollisionHelper.collideBoundingBox(entity, attemptedMove, boundingBox, entity.f_19853_, entityCollisions, filter);
        boolean moveX = attemptedMove.f_82479_ != collidedMovement.f_82479_;
        boolean moveY = attemptedMove.f_82480_ != collidedMovement.f_82480_;
        boolean moveZ = attemptedMove.f_82481_ != collidedMovement.f_82481_;
        boolean bl = touchGround = entity.m_20096_() || moveY && attemptedMove.f_82480_ < 0.0;
        if (entity.f_19793_ > 0.0f && touchGround && (moveX || moveZ)) {
            Vec3 horizontalMoveAfterVerticalStepping;
            Vec3 stepping = CollisionHelper.collideBoundingBox(entity, new Vec3(attemptedMove.f_82479_, (double)entity.f_19793_, attemptedMove.f_82481_), boundingBox, entity.f_19853_, entityCollisions, filter);
            Vec3 verticalStep = CollisionHelper.collideBoundingBox(entity, new Vec3(0.0, (double)entity.f_19793_, 0.0), boundingBox.m_82363_(attemptedMove.f_82479_, 0.0, attemptedMove.f_82481_), entity.f_19853_, entityCollisions, filter);
            if (verticalStep.f_82480_ < (double)entity.f_19793_ && (horizontalMoveAfterVerticalStepping = CollisionHelper.collideBoundingBox(entity, new Vec3(attemptedMove.f_82479_, 0.0, attemptedMove.f_82481_), boundingBox.m_82383_(verticalStep), entity.f_19853_, entityCollisions, filter).m_82549_(verticalStep)).m_165925_() > stepping.m_165925_()) {
                stepping = horizontalMoveAfterVerticalStepping;
            }
            if (stepping.m_165925_() > collidedMovement.m_165925_()) {
                Vec3 moveAfterStepping = CollisionHelper.collideBoundingBox(entity, new Vec3(0.0, -stepping.f_82480_ + attemptedMove.f_82480_, 0.0), boundingBox.m_82383_(stepping), entity.f_19853_, entityCollisions, filter);
                return stepping.m_82549_(moveAfterStepping);
            }
        }
        return collidedMovement;
    }

    @IPVanillaCopy
    public static Vec3 collideBoundingBox(Entity entity, Vec3 vec, AABB collisionBox, Level level, List<VoxelShape> potentialHits, Function<VoxelShape, VoxelShape> shapeProcessor) {
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)(potentialHits.size() + 1));
        for (VoxelShape potentialHit : potentialHits) {
            VoxelShape processed = shapeProcessor.apply(potentialHit);
            if (processed == null) continue;
            builder.add((Object)processed);
        }
        WorldBorder worldBorder = level.m_6857_();
        boolean isCloseToWorldBorder = worldBorder.m_187566_(entity, collisionBox.m_82369_(vec));
        if (isCloseToWorldBorder) {
            builder.add((Object)worldBorder.m_61946_());
        }
        Iterable blockCollisions = level.m_186434_(entity, collisionBox.m_82369_(vec));
        for (VoxelShape blockCollision : blockCollisions) {
            VoxelShape processed = shapeProcessor.apply(blockCollision);
            if (processed == null) continue;
            builder.add((Object)processed);
        }
        return IEEntity_Collision.ip_CollideWithShapes(vec, collisionBox, (List<VoxelShape>)builder.build());
    }

    private static AABB getCollisionBoxThisSide(Portal portal, AABB originalBox, Vec3 attemptedMove) {
        Vec3 clippingPos = portal.getOriginPos().m_82546_(attemptedMove);
        return CollisionHelper.clipBox(originalBox, clippingPos, portal.getNormal());
    }

    @Deprecated
    private static AABB getCollisionBoxOtherSide(PortalLike portalLike, AABB originalBox, Vec3 transformedAttemptedMove) {
        if (portalLike instanceof Portal) {
            Vec3 clippingPos;
            Portal portal = (Portal)portalLike;
            AABB otherSideBox = CollisionHelper.transformBox(portal, originalBox);
            AABB box = CollisionHelper.clipBox(otherSideBox, clippingPos = portal.getDestPos().m_82546_(transformedAttemptedMove), portal.getContentDirection());
            if (box != null) {
                boolean movingIntoPortal;
                Vec3 contentDirection = portal.getContentDirection();
                boolean bl = movingIntoPortal = contentDirection.m_82526_(transformedAttemptedMove) > 0.0;
                if (movingIntoPortal && transformedAttemptedMove.m_82556_() > 1.0 && box.m_82399_().m_82546_(otherSideBox.m_82399_()).m_82556_() < 0.2) {
                    box = box.m_82383_(contentDirection.m_82490_(transformedAttemptedMove.m_82526_(contentDirection)));
                }
            }
            return box;
        }
        PortalGroup portalGroup = (PortalGroup)portalLike;
        return CollisionHelper.transformBox(portalGroup.getFirstPortal(), originalBox);
    }

    private static AABB transformBox(PortalLike portal, AABB originalBox) {
        if (portal.getRotation() == null && portal.getScale() == 1.0) {
            return originalBox.m_82383_(portal.getDestPos().m_82546_(portal.getOriginPos()));
        }
        return Helper.transformBox(originalBox, portal::transformPoint);
    }

    public static Level getWorld(boolean isClient, ResourceKey<Level> dimension) {
        if (isClient) {
            return CHelper.getClientWorld(dimension);
        }
        return MiscHelper.getServer().m_129880_(dimension);
    }

    public static boolean isCollidingWithAnyPortal(Entity entity) {
        return ((IEEntity)entity).getCollidingPortal() != null;
    }

    public static AABB getActiveCollisionBox(Entity entity) {
        Portal collidingPortal = ((IEEntity)entity).getCollidingPortal();
        if (collidingPortal != null) {
            AABB thisSideBox = CollisionHelper.getCollisionBoxThisSide(collidingPortal, entity.m_20191_(), Vec3.f_82478_);
            if (thisSideBox != null) {
                return thisSideBox;
            }
            return new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
        return entity.m_20191_();
    }

    private static void updateGlobalPortalCollidingPortalForWorld(Level world) {
        world.m_46473_().m_6180_("global_portal_colliding_portal");
        List<Portal> globalPortals = GlobalPortalStorage.getGlobalPortals(world);
        Iterable<Entity> worldEntityList = McHelper.getWorldEntityList(world);
        if (!globalPortals.isEmpty()) {
            for (Entity entity : worldEntityList) {
                AABB entityBoundingBoxStretched = CollisionHelper.getStretchedBoundingBox(entity);
                for (Portal globalPortal : globalPortals) {
                    AABB globalPortalBoundingBox = globalPortal.m_20191_();
                    if (!entityBoundingBoxStretched.m_82381_(globalPortalBoundingBox) || !CollisionHelper.canCollideWithPortal(entity, globalPortal, 0.0f)) continue;
                    ((IEEntity)entity).notifyCollidingWithPortal(globalPortal);
                }
            }
        }
        world.m_46473_().m_7238_();
    }

    public static void init() {
        IPGlobal.postServerTickSignal.connect(() -> {
            for (ServerLevel world : MiscHelper.getServer().m_129785_()) {
                CollisionHelper.updateGlobalPortalCollidingPortalForWorld((Level)world);
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void initClient() {
        IPGlobal.postClientTickSignal.connect(CollisionHelper::tickClient);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void tickClient() {
        CollisionHelper.updateGlobalPortalCollidingStatus();
        CollisionHelper.updateClientStagnateStatus();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void updateGlobalPortalCollidingStatus() {
        if (ClientWorldLoader.getIsInitialized()) {
            for (ClientLevel world : ClientWorldLoader.getClientWorlds()) {
                CollisionHelper.updateGlobalPortalCollidingPortalForWorld((Level)world);
            }
        }
    }

    public static void notifyCollidingPortals(Portal portal, float partialTick) {
        if (!portal.teleportable) {
            return;
        }
        AABB portalBoundingBox = portal.m_20191_();
        McHelper.foreachEntitiesByBoxApproximateRegions(Entity.class, portal.f_19853_, portalBoundingBox, 3.0, entity -> {
            if (entity instanceof Portal) {
                return;
            }
            AABB entityBoxStretched = CollisionHelper.getStretchedBoundingBox(entity);
            if (!entityBoxStretched.m_82381_(portalBoundingBox)) {
                return;
            }
            boolean canCollideWithPortal = CollisionHelper.canCollideWithPortal(entity, portal, partialTick);
            if (!canCollideWithPortal) {
                return;
            }
            ((IEEntity)entity).notifyCollidingWithPortal(portal);
        });
    }

    @Deprecated
    public static void updateCollidingPortalNow(Entity entity) {
        if (entity instanceof Portal) {
            return;
        }
        entity.f_19853_.m_46473_().m_6180_("update_colliding_portal_now");
        AABB boundingBox = CollisionHelper.getStretchedBoundingBox(entity);
        McHelper.foreachEntitiesByBoxApproximateRegions(Portal.class, entity.f_19853_, boundingBox, 10.0, portal -> {
            if (boundingBox.m_82381_(portal.m_20191_()) && CollisionHelper.canCollideWithPortal(entity, portal, 0.0f)) {
                ((IEEntity)entity).notifyCollidingWithPortal((Entity)portal);
            }
        });
        entity.f_19853_.m_46473_().m_7238_();
    }

    public static AABB getStretchedBoundingBox(Entity entity) {
        Vec3 expand = McHelper.getWorldVelocity(entity).m_82490_(1.2);
        return entity.m_20191_().m_82369_(expand);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void informClientStagnant() {
        thisTickStagnate = true;
        limitedLogger.log("client movement stagnated");
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void updateClientStagnateStatus() {
        if (thisTickStagnate && lastTickStagnate) {
            Minecraft.m_91087_().f_91065_.m_93063_((Component)Component.m_237115_((String)"imm_ptl.stagnate_movement"), false);
        } else if (!thisTickStagnate && lastTickStagnate) {
            Minecraft.m_91087_().f_91065_.m_93063_((Component)Component.m_237113_((String)""), false);
        }
        lastTickStagnate = thisTickStagnate;
        thisTickStagnate = false;
    }

    public static PortalLike getCollisionHandlingUnit(Portal portal) {
        if (portal.getIsGlobal()) {
            return portal;
        }
        if (portal.f_19853_.m_5776_()) {
            return CollisionHelper.getCollisionHandlingUnitClient(portal);
        }
        return portal;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static PortalLike getCollisionHandlingUnitClient(Portal portal) {
        return PortalGroup.getPortalUnit(portal);
    }

    public static Portal chooseCollidingPortalBetweenTwo(Entity entity, Portal a, Portal b) {
        boolean movingTowardsB;
        Vec3 velocity = McHelper.getWorldVelocity(entity);
        boolean movingTowardsA = velocity.m_82526_(a.getNormal()) < 0.0;
        boolean bl = movingTowardsB = velocity.m_82526_(b.getNormal()) < 0.0;
        if (movingTowardsA) {
            return a;
        }
        return b;
    }
}

