/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral.dim_stack;

import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.api.PortalAPI;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.global_portals.GlobalPortalStorage;
import qouteall.imm_ptl.core.portal.global_portals.VerticalConnectingPortal;
import qouteall.imm_ptl.peripheral.dim_stack.DimStackEntry;
import qouteall.imm_ptl.peripheral.dim_stack.DimStackManagement;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;

public class DimStackInfo {
    public boolean loop;
    public boolean gravityTransform;
    public List<DimStackEntry> entries;

    public DimStackInfo() {
    }

    public DimStackInfo(List<DimStackEntry> entries, boolean loop, boolean gravityTransform) {
        this.entries = entries;
        this.loop = loop;
        this.gravityTransform = gravityTransform;
    }

    public static void initializeFuseViewProperty(Portal portal) {
        if (portal.getNormal().f_82480_ < 0.0) {
            portal.fuseView = true;
        }
    }

    public static void createConnectionBetween(DimStackEntry a, DimStackEntry b, boolean gravityChange) {
        ServerLevel fromWorld = McHelper.getServerWorld(a.getDimension());
        ServerLevel toWorld = McHelper.getServerWorld(b.getDimension());
        boolean xorFlipped = a.flipped ^ b.flipped;
        int fromWorldMinY = McHelper.getMinY((LevelAccessor)fromWorld);
        if (a.bottomY != null) {
            fromWorldMinY = a.bottomY;
        }
        int fromWorldMaxY = McHelper.getMaxContentYExclusive((LevelAccessor)fromWorld);
        if (a.topY != null) {
            fromWorldMaxY = a.topY;
        }
        int toWorldMinY = McHelper.getMinY((LevelAccessor)toWorld);
        if (b.bottomY != null) {
            toWorldMinY = b.bottomY;
        }
        int toWorldMaxY = McHelper.getMaxContentYExclusive((LevelAccessor)toWorld);
        if (b.topY != null) {
            toWorldMaxY = b.topY;
        }
        VerticalConnectingPortal connectingPortal = VerticalConnectingPortal.createConnectingPortal(fromWorld, a.flipped ? VerticalConnectingPortal.ConnectorType.ceil : VerticalConnectingPortal.ConnectorType.floor, toWorld, b.scale / a.scale, xorFlipped, b.horizontalRotation - a.horizontalRotation, fromWorldMinY, fromWorldMaxY, toWorldMinY, toWorldMaxY);
        VerticalConnectingPortal reverse = PortalAPI.createReversePortal(connectingPortal);
        DimStackInfo.initializeFuseViewProperty(connectingPortal);
        DimStackInfo.initializeFuseViewProperty(reverse);
        if (gravityChange) {
            connectingPortal.setTeleportChangesGravity(true);
            reverse.setTeleportChangesGravity(true);
        }
        if (a.connectsNext) {
            PortalAPI.addGlobalPortal(fromWorld, connectingPortal);
        }
        if (b.connectsPrevious) {
            PortalAPI.addGlobalPortal(toWorld, reverse);
        }
    }

    public void apply() {
        if (this.entries.isEmpty()) {
            McHelper.sendMessageToFirstLoggedPlayer((Component)Component.m_237113_((String)"Error: No dimension for dimension stack"));
            return;
        }
        MinecraftServer server = MiscHelper.getServer();
        for (DimStackEntry entry : this.entries) {
            if (server.m_129880_(entry.getDimension()) != null) continue;
            McHelper.sendMessageToFirstLoggedPlayer((Component)Component.m_237113_((String)("Failed to apply dimension stack. Missing dimension " + entry.dimensionIdStr)));
            return;
        }
        if (!GlobalPortalStorage.getGlobalPortals((Level)McHelper.getServerWorld(this.entries.get(0).getDimension())).isEmpty()) {
            Helper.err("There are already global portals when initializing dimension stack");
            return;
        }
        Helper.wrapAdjacentAndMap(this.entries.stream(), (before, after) -> {
            DimStackInfo.createConnectionBetween(before, after, this.gravityTransform);
            return null;
        }).forEach(k -> {});
        if (this.loop) {
            DimStackInfo.createConnectionBetween(this.entries.get(this.entries.size() - 1), this.entries.get(0), this.gravityTransform);
        }
        HashMap<ResourceKey<Level>, BlockState> bedrockReplacementMap = new HashMap<ResourceKey<Level>, BlockState>();
        for (DimStackEntry entry : this.entries) {
            String bedrockReplacementStr = entry.bedrockReplacementStr;
            BlockState bedrockReplacement = DimStackInfo.parseBlockString(bedrockReplacementStr);
            if (bedrockReplacement != null) {
                bedrockReplacementMap.put(entry.getDimension(), bedrockReplacement);
            }
            GlobalPortalStorage gps = GlobalPortalStorage.get(McHelper.getServerWorld(entry.getDimension()));
            gps.bedrockReplacement = bedrockReplacement;
            gps.onDataChanged();
        }
        DimStackManagement.bedrockReplacementMap = bedrockReplacementMap;
        McHelper.sendMessageToFirstLoggedPlayer((Component)Component.m_237115_((String)"imm_ptl.dim_stack_initialized"));
    }

    @Nullable
    public static BlockState parseBlockString(@Nullable String str) {
        if (str == null) {
            return null;
        }
        if (str.isEmpty()) {
            return null;
        }
        try {
            Optional block = Registry.f_122824_.m_6612_(new ResourceLocation(str));
            return block.map(Block::m_49966_).orElse(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

