/*
 * Decompiled with CFR 0.152.
 */
package qouteall.q_misc_util.api;

import com.mojang.serialization.Lifecycle;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import qouteall.q_misc_util.dimension.DimensionMisc;
import qouteall.q_misc_util.dimension.DynamicDimensionsImpl;
import qouteall.q_misc_util.dimension.ExtraDimensionStorage;

public class DimensionAPI {
    private static final Logger logger = LogManager.getLogger();

    public static void addDimension(Registry<LevelStem> levelStemRegistry, ResourceLocation dimensionId, Holder<DimensionType> dimensionTypeHolder, ChunkGenerator chunkGenerator) {
        DimensionAPI.addDimension(levelStemRegistry, dimensionId, new LevelStem(dimensionTypeHolder, chunkGenerator));
    }

    private static void addDimension(Registry<LevelStem> levelStemRegistry, ResourceLocation dimensionId, LevelStem levelStem) {
        if (levelStemRegistry instanceof MappedRegistry) {
            MappedRegistry mapped = (MappedRegistry)levelStemRegistry;
            if (!mapped.m_6566_().contains(dimensionId)) {
                mapped.m_203505_(ResourceKey.m_135785_((ResourceKey)Registry.f_122820_, (ResourceLocation)dimensionId), (Object)levelStem, Lifecycle.stable());
            }
        } else {
            throw new RuntimeException("Failed to register the dimension");
        }
        DimensionAPI.markDimensionNonPersistent(dimensionId);
    }

    @Deprecated
    public static void addDimension(long argSeed, Registry<LevelStem> dimensionOptionsRegistry, ResourceLocation dimensionId, Holder<DimensionType> dimensionTypeHolder, ChunkGenerator chunkGenerator) {
        DimensionAPI.addDimension(dimensionOptionsRegistry, dimensionId, dimensionTypeHolder, chunkGenerator);
    }

    public static void markDimensionNonPersistent(ResourceLocation dimensionId) {
        DimensionMisc.nonPersistentDimensions.add(dimensionId);
    }

    public static void addDimensionDynamically(ResourceLocation dimensionId, LevelStem levelStem) {
        DynamicDimensionsImpl.addDimensionDynamically(dimensionId, levelStem);
    }

    public static void removeDimensionDynamically(ServerLevel world) {
        DynamicDimensionsImpl.removeDimensionDynamically(world);
    }

    public static void saveDimensionConfiguration(ResourceKey<Level> dimension) {
        Validate.isTrue((!dimension.m_135782_().m_135827_().equals("minecraft") ? 1 : 0) != 0, (String)"cannot save a vanilla dimension", (Object[])new Object[0]);
        ExtraDimensionStorage.saveDimensionIntoExtraStorage(dimension);
    }

    public static boolean deleteDimensionConfiguration(ResourceKey<Level> dimension) {
        return ExtraDimensionStorage.removeDimensionFromExtraStorage(dimension);
    }

    public static interface DynamicUpdateListener {
        public void run(Set<ResourceKey<Level>> var1);
    }

    public static interface ServerDimensionsLoadCallback {
        public void run(WorldGenSettings var1, RegistryAccess var2);
    }
}

