/*
 * Decompiled with CFR 0.152.
 */
package qouteall.q_misc_util.dimension;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import qouteall.q_misc_util.dimension.DimId;

public class DimensionIdRecord {
    public static DimensionIdRecord clientRecord;
    public static DimensionIdRecord serverRecord;
    final BiMap<ResourceKey<Level>, Integer> idMap;
    final BiMap<Integer, ResourceKey<Level>> inverseMap;

    public DimensionIdRecord(BiMap<ResourceKey<Level>, Integer> data) {
        this.idMap = data;
        this.inverseMap = data.inverse();
    }

    public ResourceKey<Level> getDim(int integerId) {
        ResourceKey result = (ResourceKey)this.inverseMap.get((Object)integerId);
        if (result == null) {
            throw new RuntimeException("Missing Dimension " + integerId);
        }
        return result;
    }

    @Nullable
    public ResourceKey<Level> getDimFromIntOptional(int integerId) {
        return (ResourceKey)this.inverseMap.get((Object)integerId);
    }

    public int getIntId(ResourceKey<Level> dim) {
        Integer result = (Integer)this.idMap.get(dim);
        if (result == null) {
            throw new RuntimeException("Missing Dimension " + dim.m_135782_());
        }
        return result;
    }

    public String toString() {
        return this.idMap.entrySet().stream().map(e -> ((ResourceKey)e.getKey()).m_135782_().toString() + " -> " + e.getValue()).collect(Collectors.joining("\n"));
    }

    public static DimensionIdRecord tagToRecord(CompoundTag tag) {
        CompoundTag intids = tag.m_128469_("intids");
        if (intids == null) {
            return null;
        }
        HashBiMap bimap = HashBiMap.create();
        intids.m_128431_().forEach(dim -> {
            if (intids.m_128441_(dim)) {
                int intid = intids.m_128451_(dim);
                bimap.put(DimId.idToKey(dim), (Object)intid);
            }
        });
        return new DimensionIdRecord((BiMap<ResourceKey<Level>, Integer>)bimap);
    }

    public static CompoundTag recordToTag(DimensionIdRecord record, Predicate<ResourceKey<Level>> filter) {
        CompoundTag intids = new CompoundTag();
        record.idMap.forEach((key, intid) -> {
            if (filter.test((ResourceKey<Level>)key)) {
                intids.m_128365_(key.m_135782_().toString(), (Tag)IntTag.m_128679_((int)intid));
            }
        });
        CompoundTag result = new CompoundTag();
        result.m_128365_("intids", (Tag)intids);
        return result;
    }

    public Set<ResourceKey<Level>> getDimIdSet() {
        return new HashSet<ResourceKey<Level>>(this.idMap.keySet());
    }
}

