/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.immediatelyfast.injection.mixins.hud_batching.consumer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemStack;
import net.raphimc.immediatelyfast.feature.batching.BatchingBuffers;
import net.raphimc.immediatelyfast.feature.batching.BatchingRenderLayers;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemRenderer.class}, priority=1500)
public abstract class MixinItemRenderer {
    @ModifyArg(method={"renderGuiItem(Lnet/minecraft/world/item/ItemStack;IILnet/minecraft/client/resources/model/BakedModel;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/ItemRenderer;render(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/client/renderer/block/model/ItemTransforms$TransformType;ZLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;IILnet/minecraft/client/resources/model/BakedModel;)V"))
    private MultiBufferSource renderItemIntoBuffer(ItemStack stack, ItemTransforms.TransformType renderMode, boolean leftHanded, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay, BakedModel model) {
        if (BatchingBuffers.LIT_ITEM_MODEL_CONSUMER != null || BatchingBuffers.UNLIT_ITEM_MODEL_CONSUMER != null) {
            matrices.m_85850_().m_85861_().m_162210_(RenderSystem.m_157190_());
            return model.m_7547_() ? BatchingBuffers.LIT_ITEM_MODEL_CONSUMER : BatchingBuffers.UNLIT_ITEM_MODEL_CONSUMER;
        }
        return vertexConsumers;
    }

    @ModifyArg(method={"renderGuiItemDecorations(Lnet/minecraft/client/gui/Font;Lnet/minecraft/world/item/ItemStack;IILjava/lang/String;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/Font;drawInBatch(Ljava/lang/String;FFIZLcom/mojang/math/Matrix4f;Lnet/minecraft/client/renderer/MultiBufferSource;ZII)I"))
    private MultiBufferSource renderTextInfoBuffer(MultiBufferSource vertexConsumers) {
        return BatchingBuffers.ITEM_OVERLAY_CONSUMER != null ? BatchingBuffers.ITEM_OVERLAY_CONSUMER : vertexConsumers;
    }

    @Inject(method={"fillRect"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderGuiQuadIntoBuffer(BufferBuilder buffer, int x, int y, int width, int height, int red, int green, int blue, int alpha, CallbackInfo ci) {
        if (BatchingBuffers.ITEM_OVERLAY_CONSUMER != null) {
            ci.cancel();
            int color = alpha << 24 | red << 16 | green << 8 | blue;
            float[] shaderColor = RenderSystem.m_157197_();
            int argb = (int)(shaderColor[3] * 255.0f) << 24 | (int)(shaderColor[0] * 255.0f) << 16 | (int)(shaderColor[1] * 255.0f) << 8 | (int)(shaderColor[2] * 255.0f);
            color = FastColor.ARGB32.m_13657_((int)color, (int)argb);
            VertexConsumer vertexConsumer = BatchingBuffers.ITEM_OVERLAY_CONSUMER.m_6299_(BatchingRenderLayers.GUI_QUAD);
            vertexConsumer.m_5483_((double)x, (double)y, 0.0).m_193479_(color).m_5752_();
            vertexConsumer.m_5483_((double)x, (double)(y + height), 0.0).m_193479_(color).m_5752_();
            vertexConsumer.m_5483_((double)(x + width), (double)(y + height), 0.0).m_193479_(color).m_5752_();
            vertexConsumer.m_5483_((double)(x + width), (double)y, 0.0).m_193479_(color).m_5752_();
        }
    }
}

