/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.yabn;

import com.teamresourceful.resourcefullib.common.yabn.base.YabnArray;
import com.teamresourceful.resourcefullib.common.yabn.base.YabnElement;
import com.teamresourceful.resourcefullib.common.yabn.base.YabnObject;
import com.teamresourceful.resourcefullib.common.yabn.base.YabnPrimitive;
import com.teamresourceful.resourcefullib.common.yabn.base.primitives.DoubleContents;
import com.teamresourceful.resourcefullib.common.yabn.base.primitives.FloatContents;
import com.teamresourceful.resourcefullib.common.yabn.base.primitives.NumberPrimitiveContents;
import com.teamresourceful.resourcefullib.common.yabn.base.primitives.PrimitiveContents;
import java.util.Map;

public final class YabnCompressor {
    private YabnCompressor() {
    }

    public static YabnElement compress(YabnElement element) {
        YabnPrimitive primitive;
        PrimitiveContents primitiveContents;
        if (element instanceof YabnObject) {
            YabnObject object = (YabnObject)element;
            YabnObject newObject = new YabnObject();
            for (Map.Entry<String, YabnElement> entry : object.elements().entrySet()) {
                newObject.put(entry.getKey(), YabnCompressor.compress(entry.getValue()));
            }
            return object;
        }
        if (element instanceof YabnArray) {
            YabnArray array = (YabnArray)element;
            YabnArray newArray = new YabnArray();
            for (YabnElement item : array.elements()) {
                newArray.add(YabnCompressor.compress(item));
            }
            return newArray;
        }
        if (element instanceof YabnPrimitive && (primitiveContents = (primitive = (YabnPrimitive)element).contents()) instanceof NumberPrimitiveContents) {
            NumberPrimitiveContents numberContent = (NumberPrimitiveContents)primitiveContents;
            if (numberContent instanceof DoubleContents) {
                DoubleContents doubles = (DoubleContents)numberContent;
                if ((double)((float)doubles.getAsDouble()) == doubles.getAsDouble()) {
                    return YabnPrimitive.ofFloat(doubles.getAsFloat());
                }
            } else if (!(numberContent instanceof FloatContents)) {
                return YabnCompressor.compressNonFloatingNumber(numberContent.getAsLong());
            }
        }
        return element;
    }

    public static YabnElement compressNonFloatingNumber(long l) {
        if ((long)((byte)l) == l) {
            return YabnPrimitive.ofByte((byte)l);
        }
        if ((long)((short)l) == l) {
            return YabnPrimitive.ofShort((short)l);
        }
        if ((long)((int)l) == l) {
            return YabnPrimitive.ofInt((int)l);
        }
        return YabnPrimitive.ofLong(l);
    }

    public static YabnElement compressFloatingNumber(double d) {
        return (double)((float)d) == d ? YabnPrimitive.ofFloat((float)d) : YabnPrimitive.ofDouble(d);
    }
}

