/*
 * Decompiled with CFR 0.152.
 */
package fabric.net.mca.client.resources;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_3532;

public class ColorPalette {
    static final Map<class_2960, ColorPalette> REGISTRY = new HashMap<class_2960, ColorPalette>();
    public static final ColorPalette SKIN = new ColorPalette(new class_2960("mca", "textures/colormap/villager_skin.png"));
    public static final ColorPalette HAIR = new ColorPalette(new class_2960("mca", "textures/colormap/villager_hair.png"));
    static final Data EMPTY = new Data(1, 1, new int[]{0xFFFFFF});
    private final class_2960 id;
    Data data = EMPTY;

    public ColorPalette(class_2960 id) {
        this.id = id;
        REGISTRY.put(id, this);
    }

    public class_2960 getId() {
        return this.id;
    }

    public float[] getColor(float u, float v, float greenShift) {
        int x = ColorPalette.clampFloor(v, this.data.width - 1);
        int y = ColorPalette.clampFloor(u, this.data.height - 1);
        int color = this.data.colors[y * this.data.height + x];
        float[] result = new float[]{(float)class_1011.method_24035((int)color) / 255.0f, (float)class_1011.method_24034((int)color) / 255.0f, (float)class_1011.method_24033((int)color) / 255.0f};
        if (greenShift > 0.0f) {
            ColorPalette.applyGreenShift(result, greenShift);
        }
        return result;
    }

    private static void applyGreenShift(float[] color, float greenShift) {
        float percentDown = 1.0f - greenShift / 1.8f;
        color[0] = class_3532.method_15363((float)(color[0] * percentDown), (float)0.0f, (float)1.0f);
        color[1] = class_3532.method_15363((float)(color[1] * percentDown), (float)0.0f, (float)1.0f);
        color[2] = class_3532.method_15363((float)(color[2] * percentDown), (float)0.0f, (float)1.0f);
    }

    private static int clampFloor(float v, int max) {
        return (int)Math.floor(class_3532.method_15363((float)(v * (float)max), (float)0.0f, (float)max));
    }

    static class Data {
        final int width;
        final int height;
        final int[] colors;

        public Data(int width, int height, int[] colors) {
            this.width = width;
            this.height = height;
            this.colors = colors;
        }
    }
}

