/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca;

import dev.architectury.platform.Platform;
import forge.net.mca.Config;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class MCA {
    public static final String MOD_ID = "mca";
    public static final Logger LOGGER = LogManager.getLogger();
    private static final Map<String, Boolean> modCacheMap = new HashMap<String, Boolean>();
    public static final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private static MinecraftServer server;

    public static ResourceLocation locate(String id) {
        return new ResourceLocation(MOD_ID, id);
    }

    public static boolean isBlankString(String string) {
        return string == null || string.trim().isEmpty();
    }

    public static boolean isPlayerRendererAllowed() {
        return Config.getInstance().enableVillagerPlayerModel && Config.getInstance().playerRendererBlacklist.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals("all") || ((String)entry.getValue()).equals("block_player")).noneMatch(entry -> MCA.doesModExist((String)entry.getKey()));
    }

    public static boolean isVillagerRendererAllowed() {
        return !Config.getInstance().forceVillagerPlayerModel && Config.getInstance().playerRendererBlacklist.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals("all") || ((String)entry.getValue()).equals("block_villager")).noneMatch(entry -> MCA.doesModExist((String)entry.getKey()));
    }

    public static boolean areShadersAllowed(String key) {
        return Config.getInstance().enablePlayerShaders && Config.getInstance().playerRendererBlacklist.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals("shaders") || ((String)entry.getValue()).equals(key)).noneMatch(entry -> MCA.doesModExist((String)entry.getKey()));
    }

    public static boolean areShadersAllowed() {
        return MCA.areShadersAllowed("shaders");
    }

    public static boolean doesModExist(String modId) {
        if (!modCacheMap.containsKey(modId)) {
            Optional<Object> modData;
            try {
                modData = Optional.of(Platform.getMod((String)modId));
            }
            catch (Exception ignored) {
                modData = Optional.empty();
            }
            modCacheMap.put(modId, modData.isPresent());
        }
        return modCacheMap.get(modId);
    }

    public static void setServer(MinecraftServer server) {
        MCA.server = server;
    }

    public static Optional<MinecraftServer> getServer() {
        return Optional.ofNullable(server);
    }
}

