/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.ai.brain.tasks;

import com.google.common.collect.ImmutableMap;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.ai.MemoryModuleTypeMCA;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3;

public class ExtendedWalkTowardsTask
extends Behavior<VillagerEntityMCA> {
    private final MemoryModuleType<GlobalPos> destination;
    private final float speed;
    private final int completionRange;
    private final int maxRange;
    private final int maxRunTime;
    private static final long GAVE_UP_COOLDOWN = 1200L;
    private final Predicate<VillagerEntityMCA> canGiveUp;
    private final Consumer<VillagerEntityMCA> onGiveUp;

    public ExtendedWalkTowardsTask(MemoryModuleType<GlobalPos> destination, float speed, int completionRange, int maxRange, int maxRunTime, Predicate<VillagerEntityMCA> canGiveUp, Consumer<VillagerEntityMCA> onGiveUp) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26326_, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT, destination, (Object)MemoryStatus.VALUE_PRESENT));
        this.destination = destination;
        this.speed = speed;
        this.completionRange = completionRange;
        this.maxRange = maxRange;
        this.maxRunTime = maxRunTime;
        this.canGiveUp = canGiveUp;
        this.onGiveUp = onGiveUp;
    }

    protected boolean shouldRun(ServerLevel world, VillagerEntityMCA villager) {
        boolean b = this.stillPissed(world, villager);
        return !b;
    }

    private void giveUp(VillagerEntityMCA villager, long time) {
        Brain brain = villager.m_6274_();
        if (this.canGiveUp.test(villager)) {
            villager.m_35428_(this.destination);
            brain.m_21936_(this.destination);
            brain.m_21879_(MemoryModuleType.f_26326_, (Object)time);
            this.onGiveUp.accept(villager);
        } else {
            brain.m_21879_((MemoryModuleType)MemoryModuleTypeMCA.LAST_CANT_FIND_HOME_PISSED_MOMENT.get(), (Object)time);
            brain.m_21879_(MemoryModuleType.f_26326_, (Object)time);
        }
    }

    protected void run(ServerLevel serverWorld, VillagerEntityMCA villager, long time) {
        Brain brain = villager.m_6274_();
        brain.m_21952_(this.destination).ifPresent(pos -> {
            if (!this.dimensionMismatches(serverWorld, (GlobalPos)pos) && !this.shouldGiveUp(serverWorld, villager)) {
                if (this.exceedsMaxRange(villager, (GlobalPos)pos)) {
                    int attempt;
                    Vec3 vec3d = null;
                    for (attempt = 0; attempt < 1000 && (vec3d == null || this.exceedsMaxRange(villager, GlobalPos.m_122643_((ResourceKey)serverWorld.m_46472_(), (BlockPos)new BlockPos(vec3d)))); ++attempt) {
                        vec3d = DefaultRandomPos.m_148412_((PathfinderMob)villager, (int)15, (int)7, (Vec3)Vec3.m_82539_((Vec3i)pos.m_122646_()), (double)1.5707963705062866);
                    }
                    if (attempt == 1000) {
                        this.giveUp(villager, time);
                        return;
                    }
                    assert (vec3d != null);
                    brain.m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget(vec3d, this.speed, this.completionRange));
                } else if (!this.reachedDestination(serverWorld, villager, (GlobalPos)pos)) {
                    brain.m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget(pos.m_122646_(), this.speed, this.completionRange));
                }
            } else {
                this.giveUp(villager, time);
            }
        });
    }

    private boolean shouldGiveUp(ServerLevel world, VillagerEntityMCA villager) {
        Optional optional = villager.m_6274_().m_21952_(MemoryModuleType.f_26326_);
        return optional.filter(aLong -> world.m_46467_() - aLong > (long)this.maxRunTime).isPresent();
    }

    private boolean stillPissed(ServerLevel world, VillagerEntityMCA villager) {
        Optional optional = villager.m_6274_().m_21952_((MemoryModuleType)MemoryModuleTypeMCA.LAST_CANT_FIND_HOME_PISSED_MOMENT.get());
        return optional.filter(aLong -> world.m_46467_() - aLong < 1200L).isPresent();
    }

    private boolean exceedsMaxRange(VillagerEntityMCA villager, GlobalPos pos) {
        return pos.m_122646_().m_123333_((Vec3i)villager.m_20183_()) > this.maxRange;
    }

    private boolean dimensionMismatches(ServerLevel world, GlobalPos pos) {
        return pos.m_122640_() != world.m_46472_();
    }

    private boolean reachedDestination(ServerLevel world, VillagerEntityMCA villager, GlobalPos pos) {
        return pos.m_122640_() == world.m_46472_() && pos.m_122646_().m_123333_((Vec3i)villager.m_20183_()) <= this.completionRange;
    }
}

