/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.ai.brain.tasks;

import com.google.common.collect.ImmutableMap;
import forge.net.mca.Config;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.ai.ConversationManager;
import forge.net.mca.entity.ai.Memories;
import forge.net.mca.entity.ai.Relationship;
import forge.net.mca.entity.ai.relationship.CompassionateEntity;
import forge.net.mca.server.world.data.PlayerSaveData;
import forge.net.mca.server.world.data.Village;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.player.Player;

public class GreetPlayerTask
extends Behavior<VillagerEntityMCA> {
    private static final int MAX_COOLDOWN = 100;
    private int cooldown = 0;

    public GreetPlayerTask() {
        super((Map)ImmutableMap.of(), 0);
    }

    protected boolean shouldRun(ServerLevel world, VillagerEntityMCA entity) {
        --this.cooldown;
        return this.cooldown < 0;
    }

    protected void run(ServerLevel world, VillagerEntityMCA villager, long time) {
        this.cooldown = 100;
        GreetPlayerTask.getPlayer(villager).ifPresent(player -> {
            Memories memories = villager.getVillagerBrain().getMemoriesForPlayer((Player)player);
            int day = (int)(villager.f_19853_.m_46468_() / 24000L);
            memories.setLastSeen(day);
            String phrase = memories.getHearts() < 0 ? "welcomeFoe" : "welcome";
            villager.conversationManager.addMessage(new ConversationManager.PhraseText((Entity)player, phrase));
        });
    }

    private static Optional<? extends Player> getPlayer(VillagerEntityMCA villager) {
        return ((ServerLevel)villager.f_19853_).m_6907_().stream().filter(p -> GreetPlayerTask.isWithinSeeRange(villager, (Player)p)).filter(p -> GreetPlayerTask.shouldGreet(villager, p)).findFirst();
    }

    private static boolean shouldGreet(VillagerEntityMCA villager, ServerPlayer player) {
        Optional<Integer> id = PlayerSaveData.get(player).getLastSeenVillageId();
        Optional<Village> village = villager.getResidency().getHomeVillage();
        if (id.isPresent() && village.isPresent() && id.get().intValue() == village.get().getId()) {
            Memories memories = villager.getVillagerBrain().getMemoriesForPlayer((Player)player);
            int day = (int)(villager.f_19853_.m_46468_() / 24000L);
            if (Relationship.IS_MARRIED.test((CompassionateEntity<?>)villager, (Entity)player) || Relationship.IS_RELATIVE.test((CompassionateEntity<?>)villager, (Entity)player) || Math.abs(memories.getHearts()) >= Config.getInstance().greetHeartsThreshold) {
                long diff = (long)day - memories.getLastSeen();
                if (diff > (long)Config.getInstance().greetAfterDays && memories.getLastSeen() > 0L) {
                    return true;
                }
                if (diff > 0L) {
                    memories.setLastSeen(day);
                }
            } else {
                memories.setLastSeen(day);
            }
        }
        return false;
    }

    private static boolean isWithinSeeRange(VillagerEntityMCA villager, Player player) {
        return villager.m_20183_().m_123314_((Vec3i)player.m_20183_(), 32.0);
    }
}

