/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.forge;

import com.mojang.brigadier.CommandDispatcher;
import forge.net.mca.MCA;
import forge.net.mca.MCAClient;
import forge.net.mca.server.ServerInteractionManager;
import forge.net.mca.server.command.AdminCommand;
import forge.net.mca.server.command.Command;
import forge.net.mca.server.world.data.VillageManager;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="mca")
public class ForgeBusEvents {
    @SubscribeEvent
    public static void onCommandRegister(RegisterCommandsEvent event) {
        AdminCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        Command.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        if (!event.level.f_46443_ && event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.END) {
            VillageManager.get((ServerLevel)event.level).tick();
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.END) {
            ServerInteractionManager.getInstance().tick();
        }
        MCA.setServer(event.getServer());
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (!event.getEntity().f_19853_.f_46443_) {
            VillageManager.get((ServerLevel)event.getEntity().f_19853_).getBabies().pop(event.getEntity());
        }
    }

    @SubscribeEvent
    public static void OnEntityJoinWorldEvent(EntityJoinLevelEvent event) {
        if (event.getEntity().f_19853_.f_46443_ && (Minecraft.m_91087_().f_91074_ == null || event.getEntity().m_20148_().equals(Minecraft.m_91087_().f_91074_.m_20148_()))) {
            MCAClient.onLogin();
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        ServerInteractionManager.getInstance().onPlayerJoin((ServerPlayer)event.getEntity());
    }

    @SubscribeEvent
    public static void onParticleFactoryRegistration(TickEvent.ClientTickEvent event) {
        MCAClient.tickClient(Minecraft.m_91087_());
    }
}

