/*
 * Decompiled with CFR 0.152.
 */
package quilt.net.mca.entity.ai.brain.tasks;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4215;
import quilt.net.mca.entity.VillagerEntityMCA;
import quilt.net.mca.entity.ai.ConversationManager;
import quilt.net.mca.entity.ai.MemoryModuleTypeMCA;

public class DeliverMessageTask
extends class_4097<VillagerEntityMCA> {
    private static final int MAX_COOLDOWN = 10;
    private static final int TALKING_TIME_MIN = 100;
    private static final int TALKING_TIME_MAX = 500;
    private static final long MIN_TIME_BETWEEN_SOUND = 6000L;
    private Optional<ConversationManager.Message> message = Optional.empty();
    private int cooldown;
    private int talked;
    private long lastInteraction = Long.MIN_VALUE;
    private class_243 lastInteractionPos;

    public DeliverMessageTask() {
        super((Map)ImmutableMap.of((Object)class_4140.field_18445, (Object)class_4141.field_18458, (Object)class_4140.field_18446, (Object)class_4141.field_18458, (Object)class_4140.field_18447, (Object)class_4141.field_18458), 600);
    }

    protected boolean shouldRun(class_3218 world, VillagerEntityMCA villager) {
        if (this.cooldown > 0) {
            --this.cooldown;
            return false;
        }
        this.cooldown = 10;
        this.message = DeliverMessageTask.getMessage(villager);
        return this.message.isPresent() && DeliverMessageTask.isWithinSeeRange(villager, this.message.get().getReceiver());
    }

    protected void run(class_3218 world, VillagerEntityMCA villager, long time) {
        this.message.ifPresent(m -> {
            this.talked = 0;
        });
    }

    protected boolean shouldKeepRunning(class_3218 world, VillagerEntityMCA villager, long time) {
        return this.talked < this.getMaxTalkingTime() && !villager.getVillagerBrain().isPanicking() && !villager.method_6113();
    }

    private int getMaxTalkingTime() {
        class_243 pos;
        if (this.message.isPresent() && this.lastInteractionPos != null && this.lastInteractionPos.method_24802((class_2374)(pos = this.message.get().getReceiver().method_19538()), 1.0)) {
            return 500;
        }
        return 100;
    }

    protected void keepRunning(class_3218 world, VillagerEntityMCA villager, long time) {
        this.message.ifPresent(m -> {
            class_1297 patt2730$temp = m.getReceiver();
            if (patt2730$temp instanceof class_1309) {
                class_1309 e = (class_1309)patt2730$temp;
                villager.method_18868().method_18878(class_4140.field_18447, (Object)e);
                class_4215.method_19554((class_1309)villager, (class_1309)e);
            }
            if (this.talked == 0) {
                if (DeliverMessageTask.isWithinRange(villager, m.getReceiver())) {
                    if (time - this.lastInteraction > 6000L) {
                        villager.playWelcomeSound();
                    }
                    this.lastInteraction = time;
                    this.lastInteractionPos = m.getReceiver().method_19538();
                    m.deliver();
                    this.talked = 1;
                } else {
                    class_4215.method_24557((class_1309)villager, (class_1297)m.getReceiver(), (float)0.65f, (int)2);
                }
            } else {
                class_4215.method_24557((class_1309)villager, (class_1297)m.getReceiver(), (float)0.45f, (int)2);
                ++this.talked;
            }
        });
    }

    protected void finishRunning(class_3218 world, VillagerEntityMCA villager, long time) {
        this.message = Optional.empty();
        villager.method_18868().method_18875(class_4140.field_18447);
        villager.method_18868().method_18875(class_4140.field_18445);
        villager.method_18868().method_18875(class_4140.field_18446);
    }

    private static Optional<ConversationManager.Message> getMessage(VillagerEntityMCA villager) {
        return villager.conversationManager.getCurrentMessage();
    }

    private static boolean isWithinRange(VillagerEntityMCA villager, class_1297 player) {
        if (villager.method_18868().method_18904((class_4140)MemoryModuleTypeMCA.STAYING.get()).isPresent()) {
            return true;
        }
        return villager.method_24515().method_19771((class_2382)player.method_24515(), 3.0);
    }

    private static boolean isWithinSeeRange(VillagerEntityMCA villager, class_1297 player) {
        return villager.method_24515().method_19771((class_2382)player.method_24515(), 64.0);
    }
}

