/*
 * Decompiled with CFR 0.152.
 */
package quilt.net.mca.network.c2s;

import java.util.Locale;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import quilt.net.mca.cobalt.network.Message;
import quilt.net.mca.server.world.data.Building;
import quilt.net.mca.server.world.data.Village;
import quilt.net.mca.server.world.data.VillageManager;

public class ReportBuildingMessage
implements Message {
    private static final long serialVersionUID = 3510050513221709603L;
    private final Action action;
    private final String data;

    public ReportBuildingMessage(Action action, String data) {
        this.action = action;
        this.data = data;
    }

    public ReportBuildingMessage(Action action) {
        this(action, null);
    }

    @Override
    public void receive(class_3222 player) {
        VillageManager villages = VillageManager.get(player.method_14220());
        switch (this.action) {
            case ADD: 
            case ADD_ROOM: {
                Building.validationResult result = villages.processBuilding(player.method_24515(), true, this.action == Action.ADD_ROOM);
                player.method_7353((class_2561)class_2561.method_43471((String)("blueprint.scan." + result.name().toLowerCase(Locale.ENGLISH))), true);
                break;
            }
            case AUTO_SCAN: {
                villages.findNearestVillage((class_1297)player).ifPresent(Village::toggleAutoScan);
                break;
            }
            case FULL_SCAN: {
                villages.findNearestVillage((class_1297)player).ifPresent(buildings -> buildings.getBuildings().values().stream().toList().forEach(b -> villages.processBuilding(b.getCenter(), true, b.isStrictScan())));
                break;
            }
            case FORCE_TYPE: 
            case REMOVE: {
                Optional<Village> village = villages.findNearestVillage((class_1297)player);
                Optional building = village.flatMap(v -> v.getBuildings().values().stream().filter(b -> b.containsPos((class_2382)player.method_24515())).findAny());
                if (building.isPresent()) {
                    if (this.action == Action.FORCE_TYPE) {
                        if (((Building)building.get()).getType().equals(this.data)) {
                            ((Building)building.get()).setTypeForced(false);
                            ((Building)building.get()).determineType();
                            break;
                        }
                        ((Building)building.get()).setTypeForced(true);
                        ((Building)building.get()).setType(this.data);
                        break;
                    }
                    village.get().removeBuilding(((Building)building.get()).getId());
                    break;
                }
                player.method_7353((class_2561)class_2561.method_43471((String)"blueprint.noBuilding"), true);
            }
        }
    }

    public static enum Action {
        AUTO_SCAN,
        ADD_ROOM,
        ADD,
        REMOVE,
        FORCE_TYPE,
        FULL_SCAN;

    }
}

