/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.jei.category;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.compat.jei.category.animations.AnimatedCrafter;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.utility.Components;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.IShapedRecipe;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class MechanicalCraftingCategory
extends CreateRecipeCategory<CraftingRecipe> {
    private final AnimatedCrafter crafter = new AnimatedCrafter();
    static int maxSize = 100;

    public MechanicalCraftingCategory(CreateRecipeCategory.Info<CraftingRecipe> info) {
        super(info);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CraftingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.OUTPUT, 134, 81).addItemStack(recipe.m_8043_());
        int x = MechanicalCraftingCategory.getXPadding(recipe);
        int y = MechanicalCraftingCategory.getYPadding(recipe);
        float scale = MechanicalCraftingCategory.getScale(recipe);
        CrafterIngredientRenderer renderer = new CrafterIngredientRenderer(recipe);
        int i = 0;
        for (Ingredient ingredient : recipe.m_7527_()) {
            float f = 19.0f * scale;
            int xPosition = (int)((float)(x + 1) + (float)(i % MechanicalCraftingCategory.getWidth(recipe)) * f);
            int yPosition = (int)((float)(y + 1) + (float)(i / MechanicalCraftingCategory.getWidth(recipe)) * f);
            builder.addSlot(RecipeIngredientRole.INPUT, xPosition, yPosition).setCustomRenderer((IIngredientType)VanillaTypes.ITEM_STACK, (IIngredientRenderer)renderer).addIngredients(ingredient);
            ++i;
        }
    }

    public static float getScale(CraftingRecipe recipe) {
        int w = MechanicalCraftingCategory.getWidth(recipe);
        int h = MechanicalCraftingCategory.getHeight(recipe);
        return Math.min(1.0f, (float)maxSize / (19.0f * (float)Math.max(w, h)));
    }

    public static int getYPadding(CraftingRecipe recipe) {
        return 53 - (int)((double)(MechanicalCraftingCategory.getScale(recipe) * (float)MechanicalCraftingCategory.getHeight(recipe) * 19.0f) * 0.5);
    }

    public static int getXPadding(CraftingRecipe recipe) {
        return 53 - (int)((double)(MechanicalCraftingCategory.getScale(recipe) * (float)MechanicalCraftingCategory.getWidth(recipe) * 19.0f) * 0.5);
    }

    private static int getWidth(CraftingRecipe recipe) {
        return recipe instanceof IShapedRecipe ? ((IShapedRecipe)recipe).getRecipeWidth() : 1;
    }

    private static int getHeight(CraftingRecipe recipe) {
        return recipe instanceof IShapedRecipe ? ((IShapedRecipe)recipe).getRecipeHeight() : 1;
    }

    public void draw(CraftingRecipe recipe, IRecipeSlotsView iRecipeSlotsView, PoseStack matrixStack, double mouseX, double mouseY) {
        matrixStack.m_85836_();
        float scale = MechanicalCraftingCategory.getScale(recipe);
        matrixStack.m_85837_((double)MechanicalCraftingCategory.getXPadding(recipe), (double)MechanicalCraftingCategory.getYPadding(recipe), 0.0);
        for (int row = 0; row < MechanicalCraftingCategory.getHeight(recipe); ++row) {
            for (int col = 0; col < MechanicalCraftingCategory.getWidth(recipe); ++col) {
                if (((Ingredient)recipe.m_7527_().get(row * MechanicalCraftingCategory.getWidth(recipe) + col)).m_43947_()) continue;
                matrixStack.m_85836_();
                matrixStack.m_85837_((double)((float)(col * 19) * scale), (double)((float)(row * 19) * scale), 0.0);
                matrixStack.m_85841_(scale, scale, scale);
                AllGuiTextures.JEI_SLOT.render(matrixStack, 0, 0);
                matrixStack.m_85849_();
            }
        }
        matrixStack.m_85849_();
        AllGuiTextures.JEI_SLOT.render(matrixStack, 133, 80);
        AllGuiTextures.JEI_DOWN_ARROW.render(matrixStack, 128, 59);
        this.crafter.draw(matrixStack, 129, 25);
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.0, 300.0);
        int amount = 0;
        for (Ingredient ingredient : recipe.m_7527_()) {
            if (Ingredient.f_43901_ == ingredient) continue;
            ++amount;
        }
        Minecraft.m_91087_().f_91062_.m_92750_(matrixStack, "" + amount, 142.0f, 39.0f, 0xFFFFFF);
        matrixStack.m_85849_();
    }

    private static final class CrafterIngredientRenderer
    implements IIngredientRenderer<ItemStack> {
        private final CraftingRecipe recipe;
        private final float scale;

        public CrafterIngredientRenderer(CraftingRecipe recipe) {
            this.recipe = recipe;
            this.scale = MechanicalCraftingCategory.getScale(recipe);
        }

        public void render(PoseStack matrixStack, @NotNull ItemStack ingredient) {
            matrixStack.m_85836_();
            float scale = MechanicalCraftingCategory.getScale(this.recipe);
            matrixStack.m_85841_(scale, scale, scale);
            if (ingredient != null) {
                PoseStack modelViewStack = RenderSystem.m_157191_();
                modelViewStack.m_85836_();
                modelViewStack.m_166854_(matrixStack.m_85850_().m_85861_());
                RenderSystem.m_157182_();
                RenderSystem.m_69482_();
                Minecraft minecraft = Minecraft.m_91087_();
                Font font = this.getFontRenderer(minecraft, ingredient);
                ItemRenderer itemRenderer = minecraft.m_91291_();
                itemRenderer.m_115218_(ingredient, 0, 0);
                itemRenderer.m_115174_(font, ingredient, 0, 0, null);
                RenderSystem.m_69461_();
                modelViewStack.m_85849_();
                RenderSystem.m_157182_();
            }
            matrixStack.m_85849_();
        }

        public int getWidth() {
            return (int)(16.0f * this.scale);
        }

        public int getHeight() {
            return (int)(16.0f * this.scale);
        }

        public List<Component> getTooltip(ItemStack ingredient, TooltipFlag tooltipFlag) {
            Minecraft minecraft = Minecraft.m_91087_();
            LocalPlayer player = minecraft.f_91074_;
            try {
                return ingredient.m_41651_((Player)player, tooltipFlag);
            }
            catch (LinkageError | RuntimeException e) {
                ArrayList<Component> list = new ArrayList<Component>();
                MutableComponent crash = Components.translatable("jei.tooltip.error.crash");
                list.add((Component)crash.m_130940_(ChatFormatting.RED));
                return list;
            }
        }
    }
}

