/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.processing.burner;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.foundation.utility.RegisteredObjects;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.phys.Vec3;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class BlazeBurnerBlockItem
extends BlockItem {
    private final boolean capturedBlaze;

    public static BlazeBurnerBlockItem empty(Item.Properties properties) {
        return new BlazeBurnerBlockItem((Block)AllBlocks.BLAZE_BURNER.get(), properties, false);
    }

    public static BlazeBurnerBlockItem withBlaze(Block block, Item.Properties properties) {
        return new BlazeBurnerBlockItem(block, properties, true);
    }

    public void m_6192_(Map<Block, Item> p_195946_1_, Item p_195946_2_) {
        if (!this.hasCapturedBlaze()) {
            return;
        }
        super.m_6192_(p_195946_1_, p_195946_2_);
    }

    private BlazeBurnerBlockItem(Block block, Item.Properties properties, boolean capturedBlaze) {
        super(block, properties);
        this.capturedBlaze = capturedBlaze;
    }

    public void m_6787_(CreativeModeTab p_150895_1_, NonNullList<ItemStack> p_150895_2_) {
        if (!this.hasCapturedBlaze()) {
            return;
        }
        super.m_6787_(p_150895_1_, p_150895_2_);
    }

    public String m_5524_() {
        return this.hasCapturedBlaze() ? super.m_5524_() : "item.create." + RegisteredObjects.getKeyOrThrow((Item)this).m_135815_();
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (this.hasCapturedBlaze()) {
            return super.m_6225_(context);
        }
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockEntity be = world.m_7702_(pos);
        Player player = context.m_43723_();
        if (!(be instanceof SpawnerBlockEntity)) {
            return super.m_6225_(context);
        }
        BaseSpawner spawner = ((SpawnerBlockEntity)be).m_59801_();
        List<SpawnData> possibleSpawns = spawner.f_45443_.m_146338_().stream().map(WeightedEntry.Wrapper::m_146310_).toList();
        if (possibleSpawns.isEmpty()) {
            possibleSpawns = new ArrayList<SpawnData>();
            possibleSpawns.add(spawner.f_45444_);
        }
        ResourceLocation blazeId = RegisteredObjects.getKeyOrThrow(EntityType.f_20551_);
        for (SpawnData e : possibleSpawns) {
            ResourceLocation spawnerEntityId = new ResourceLocation(e.f_186561_().m_128461_("id"));
            if (!spawnerEntityId.equals((Object)blazeId)) continue;
            this.spawnCaptureEffects(world, VecHelper.getCenterOf((Vec3i)pos));
            if (world.f_46443_ || player == null) {
                return InteractionResult.SUCCESS;
            }
            this.giveBurnerItemTo(player, context.m_43722_(), context.m_43724_());
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(context);
    }

    public InteractionResult m_6880_(ItemStack heldItem, Player player, LivingEntity entity, InteractionHand hand) {
        if (this.hasCapturedBlaze()) {
            return InteractionResult.PASS;
        }
        if (!(entity instanceof Blaze)) {
            return InteractionResult.PASS;
        }
        Level world = player.f_19853_;
        this.spawnCaptureEffects(world, entity.m_20182_());
        if (world.f_46443_) {
            return InteractionResult.FAIL;
        }
        this.giveBurnerItemTo(player, heldItem, hand);
        entity.m_146870_();
        return InteractionResult.FAIL;
    }

    protected void giveBurnerItemTo(Player player, ItemStack heldItem, InteractionHand hand) {
        ItemStack filled = AllBlocks.BLAZE_BURNER.asStack();
        if (!player.m_7500_()) {
            heldItem.m_41774_(1);
        }
        if (heldItem.m_41619_()) {
            player.m_21008_(hand, filled);
            return;
        }
        player.m_150109_().m_150079_(filled);
    }

    private void spawnCaptureEffects(Level world, Vec3 vec) {
        if (world.f_46443_) {
            for (int i = 0; i < 40; ++i) {
                Vec3 motion = VecHelper.offsetRandomly(Vec3.f_82478_, world.f_46441_, 0.125f);
                world.m_7106_((ParticleOptions)ParticleTypes.f_123744_, vec.f_82479_, vec.f_82480_, vec.f_82481_, motion.f_82479_, motion.f_82480_, motion.f_82481_);
                Vec3 circle = motion.m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_(0.5);
                world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, circle.f_82479_, vec.f_82480_, circle.f_82481_, 0.0, -0.125, 0.0);
            }
            return;
        }
        BlockPos soundPos = new BlockPos(vec);
        world.m_5594_(null, soundPos, SoundEvents.f_11704_, SoundSource.HOSTILE, 0.25f, 0.75f);
        world.m_5594_(null, soundPos, SoundEvents.f_11937_, SoundSource.HOSTILE, 0.5f, 0.75f);
    }

    public boolean hasCapturedBlaze() {
        return this.capturedBlaze;
    }
}

