/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.redstone.smartObserver;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.fluids.FluidTransportBehaviour;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.logistics.funnel.FunnelBlockEntity;
import com.simibubi.create.content.redstone.DirectedDirectionalBlock;
import com.simibubi.create.content.redstone.smartObserver.SmartObserverBlockEntity;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import com.simibubi.create.foundation.utility.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public class SmartObserverBlock
extends DirectedDirectionalBlock
implements IBE<SmartObserverBlockEntity> {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    public SmartObserverBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{POWERED}));
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = this.m_49966_();
        Capability itemCap = CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
        Capability fluidCap = CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
        Direction preferredFacing = null;
        for (Direction face : context.m_6232_()) {
            BlockPos offsetPos = context.m_8083_().m_121945_(face);
            Level world = context.m_43725_();
            boolean canDetect = false;
            BlockEntity blockEntity = world.m_7702_(offsetPos);
            if (BlockEntityBehaviour.get(blockEntity, TransportedItemStackHandlerBehaviour.TYPE) != null) {
                canDetect = true;
            } else if (BlockEntityBehaviour.get(blockEntity, FluidTransportBehaviour.TYPE) != null) {
                canDetect = true;
            } else if (blockEntity != null && (blockEntity.getCapability(itemCap).isPresent() || blockEntity.getCapability(fluidCap).isPresent())) {
                canDetect = true;
            } else if (blockEntity instanceof FunnelBlockEntity) {
                canDetect = true;
            }
            if (!canDetect) continue;
            preferredFacing = face;
            break;
        }
        if (preferredFacing == null) {
            Direction facing = context.m_7820_();
            Direction direction = preferredFacing = context.m_43723_() != null && context.m_43723_().m_20161_() ? facing : facing.m_122424_();
        }
        if (preferredFacing.m_122434_() == Direction.Axis.Y) {
            state = (BlockState)state.m_61124_((Property)TARGET, (Comparable)(preferredFacing == Direction.UP ? AttachFace.CEILING : AttachFace.FLOOR));
            preferredFacing = context.m_8125_();
        }
        return (BlockState)state.m_61124_((Property)f_54117_, preferredFacing);
    }

    public boolean m_7899_(BlockState state) {
        return (Boolean)state.m_61143_((Property)POWERED);
    }

    public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return this.m_7899_(blockState) && (side == null || side != ((Direction)blockState.m_61143_((Property)f_54117_)).m_122424_()) ? 15 : 0;
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)), 2);
        worldIn.m_46672_(pos, (Block)this);
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return side != ((Direction)state.m_61143_((Property)f_54117_)).m_122424_();
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        IBE.onRemove(state, worldIn, pos, newState);
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        InvManipulationBehaviour behaviour = BlockEntityBehaviour.get((BlockGetter)worldIn, pos, InvManipulationBehaviour.TYPE);
        if (behaviour != null) {
            behaviour.onNeighborChanged(fromPos);
        }
    }

    public void onFunnelTransfer(Level world, BlockPos funnelPos, ItemStack transferred) {
        for (Direction direction : Iterate.horizontalDirections) {
            BlockPos detectorPos = funnelPos.m_121945_(direction);
            BlockState detectorState = world.m_8055_(detectorPos);
            if (!AllBlocks.SMART_OBSERVER.has(detectorState) || detectorState.m_61143_((Property)f_54117_) != direction.m_122424_()) continue;
            this.withBlockEntityDo((BlockGetter)world, detectorPos, be -> {
                FilteringBehaviour filteringBehaviour = BlockEntityBehaviour.get(be, FilteringBehaviour.TYPE);
                if (filteringBehaviour == null) {
                    return;
                }
                if (!filteringBehaviour.test(transferred)) {
                    return;
                }
                be.activate(4);
            });
        }
    }

    @Override
    public Class<SmartObserverBlockEntity> getBlockEntityClass() {
        return SmartObserverBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends SmartObserverBlockEntity> getBlockEntityType() {
        return (BlockEntityType)AllBlockEntityTypes.SMART_OBSERVER.get();
    }
}

