/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.bogey;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.util.transform.Transform;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.simpleRelays.ShaftBlock;
import com.simibubi.create.content.trains.bogey.BogeyRenderer;
import com.simibubi.create.content.trains.bogey.BogeySizes;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.Iterate;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class StandardBogeyRenderer {

    public static class LargeStandardBogeyRenderer
    extends BogeyRenderer {
        @Override
        public void initialiseContraptionModelData(MaterialManager materialManager) {
            this.createModelInstances(materialManager, AllPartialModels.LARGE_BOGEY_WHEELS, AllPartialModels.BOGEY_DRIVE, AllPartialModels.BOGEY_PISTON, AllPartialModels.BOGEY_PIN);
            this.createModelInstances(materialManager, (BlockState)AllBlocks.SHAFT.getDefaultState().m_61124_((Property)ShaftBlock.AXIS, (Comparable)Direction.Axis.X), 2);
        }

        @Override
        public BogeySizes.BogeySize getSize() {
            return BogeySizes.LARGE;
        }

        @Override
        public void render(CompoundTag bogeyData, float wheelAngle, PoseStack ms, int light, VertexConsumer vb, boolean inContraption) {
            boolean inInstancedContraption = vb == null;
            Transform<?>[] secondaryShafts = this.getTransformsFromBlockState((BlockState)AllBlocks.SHAFT.getDefaultState().m_61124_((Property)ShaftBlock.AXIS, (Comparable)Direction.Axis.X), ms, inInstancedContraption, 2);
            for (int i : Iterate.zeroAndOne) {
                Transform<?> secondShaft = secondaryShafts[i];
                ((Transform)((Transform)((Transform)secondShaft.translate(-0.5, 0.25, (double)(0.5f + (float)(i * -2)))).centre()).rotateX((double)wheelAngle)).unCentre();
                LargeStandardBogeyRenderer.finalize(secondShaft, ms, light, vb);
            }
            Transform<?> bogeyDrive = this.getTransformFromPartial(AllPartialModels.BOGEY_DRIVE, ms, inInstancedContraption);
            LargeStandardBogeyRenderer.finalize(bogeyDrive, ms, light, vb);
            Transform bogeyPiston = (Transform)this.getTransformFromPartial(AllPartialModels.BOGEY_PISTON, ms, inInstancedContraption).translate(0.0, 0.0, 0.25 * Math.sin(AngleHelper.rad(wheelAngle)));
            LargeStandardBogeyRenderer.finalize(bogeyPiston, ms, light, vb);
            if (!inInstancedContraption) {
                ms.m_85836_();
            }
            Transform bogeyWheels = (Transform)((Transform)this.getTransformFromPartial(AllPartialModels.LARGE_BOGEY_WHEELS, ms, inInstancedContraption).translate(0.0, 1.0, 0.0)).rotateX((double)wheelAngle);
            LargeStandardBogeyRenderer.finalize(bogeyWheels, ms, light, vb);
            Transform bogeyPin = (Transform)((Transform)((Transform)((Transform)this.getTransformFromPartial(AllPartialModels.BOGEY_PIN, ms, inInstancedContraption).translate(0.0, 1.0, 0.0)).rotateX((double)wheelAngle)).translate(0.0, 0.25, 0.0)).rotateX((double)(-wheelAngle));
            LargeStandardBogeyRenderer.finalize(bogeyPin, ms, light, vb);
            if (!inInstancedContraption) {
                ms.m_85849_();
            }
        }
    }

    public static class SmallStandardBogeyRenderer
    extends BogeyRenderer {
        @Override
        public void initialiseContraptionModelData(MaterialManager materialManager) {
            this.createModelInstances(materialManager, AllPartialModels.SMALL_BOGEY_WHEELS, 2);
            this.createModelInstances(materialManager, AllPartialModels.BOGEY_FRAME);
        }

        @Override
        public BogeySizes.BogeySize getSize() {
            return BogeySizes.SMALL;
        }

        @Override
        public void render(CompoundTag bogeyData, float wheelAngle, PoseStack ms, int light, VertexConsumer vb, boolean inContraption) {
            boolean inInstancedContraption = vb == null;
            Transform<?> transform = this.getTransformFromPartial(AllPartialModels.BOGEY_FRAME, ms, inInstancedContraption);
            SmallStandardBogeyRenderer.finalize(transform, ms, light, vb);
            Transform<?>[] wheels = this.getTransformsFromPartial(AllPartialModels.SMALL_BOGEY_WHEELS, ms, inInstancedContraption, 2);
            for (int side : Iterate.positiveAndNegative) {
                if (!inInstancedContraption) {
                    ms.m_85836_();
                }
                Transform<?> wheel = wheels[(side + 1) / 2];
                ((Transform)wheel.translate(0.0, 0.75, (double)side)).rotateX((double)wheelAngle);
                SmallStandardBogeyRenderer.finalize(wheel, ms, light, vb);
                if (inInstancedContraption) continue;
                ms.m_85849_();
            }
        }
    }

    public static class CommonStandardBogeyRenderer
    extends BogeyRenderer.CommonRenderer {
        @Override
        public void initialiseContraptionModelData(MaterialManager materialManager) {
            this.createModelInstances(materialManager, (BlockState)AllBlocks.SHAFT.getDefaultState().m_61124_((Property)ShaftBlock.AXIS, (Comparable)Direction.Axis.Z), 2);
        }

        @Override
        public void render(CompoundTag bogeyData, float wheelAngle, PoseStack ms, int light, VertexConsumer vb, boolean inContraption) {
            boolean inInstancedContraption = vb == null;
            Transform<?>[] shafts = this.getTransformsFromBlockState((BlockState)AllBlocks.SHAFT.getDefaultState().m_61124_((Property)ShaftBlock.AXIS, (Comparable)Direction.Axis.Z), ms, inInstancedContraption, 2);
            for (int i : Iterate.zeroAndOne) {
                ((Transform)((Transform)((Transform)shafts[i].translate(-0.5, 0.25, (double)(i * -1))).centre()).rotateZ((double)wheelAngle)).unCentre();
                CommonStandardBogeyRenderer.finalize(shafts[i], ms, light, vb);
            }
        }
    }
}

