/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.entity;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.Create;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TrainIconType {
    public static Map<ResourceLocation, TrainIconType> REGISTRY = new HashMap<ResourceLocation, TrainIconType>();
    ResourceLocation sheet;
    ResourceLocation id;
    int x;
    int y;
    public static final int ENGINE = -1;
    public static final int FLIPPED_ENGINE = -2;

    public static void register(ResourceLocation id, ResourceLocation sheet, int x, int y) {
        REGISTRY.put(id, new TrainIconType(id, sheet, x, y));
    }

    public TrainIconType(ResourceLocation id, ResourceLocation sheet, int x, int y) {
        this.id = id;
        this.sheet = sheet;
        this.x = x;
        this.y = y;
    }

    public static TrainIconType byId(ResourceLocation id) {
        return REGISTRY.getOrDefault(id, TrainIconType.getDefault());
    }

    public static TrainIconType getDefault() {
        return REGISTRY.get(Create.asResource("traditional"));
    }

    public ResourceLocation getId() {
        return this.id;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int render(int lengthOrEngine, PoseStack ms, int x, int y) {
        int offset = this.getIconOffset(lengthOrEngine);
        int width = this.getIconWidth(lengthOrEngine);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.sheet);
        GuiComponent.m_93143_((PoseStack)ms, (int)x, (int)y, (int)0, (float)(this.x + offset), (float)this.y, (int)width, (int)10, (int)256, (int)256);
        return width;
    }

    public int getIconWidth(int lengthOrEngine) {
        if (lengthOrEngine == -2) {
            return 19;
        }
        if (lengthOrEngine == -1) {
            return 19;
        }
        if (lengthOrEngine < 3) {
            return 7;
        }
        if (lengthOrEngine < 9) {
            return 13;
        }
        return 19;
    }

    public int getIconOffset(int lengthOrEngine) {
        if (lengthOrEngine == -2) {
            return 0;
        }
        if (lengthOrEngine == -1) {
            return 62;
        }
        if (lengthOrEngine < 3) {
            return 34;
        }
        if (lengthOrEngine < 9) {
            return 20;
        }
        return 42;
    }

    static {
        ResourceLocation sheet = Create.asResource("textures/gui/assemble.png");
        TrainIconType.register(Create.asResource("traditional"), sheet, 2, 205);
        TrainIconType.register(Create.asResource("electric"), sheet, 2, 216);
        TrainIconType.register(Create.asResource("modern"), sheet, 2, 227);
    }
}

